/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config.db;

import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

@Profile(value={"nflow.db.postgresql"})
@Configuration
public class PgDatabaseConfiguration
extends DatabaseConfiguration {
    public PgDatabaseConfiguration() {
        super("postgresql");
    }

    @Override
    @Bean
    public SQLVariants sqlVariants(Environment env) {
        return new PostgreSQLVariants();
    }

    public static class PostgreSQLVariants
    implements SQLVariants {
        @Override
        public String currentTimePlusSeconds(int seconds) {
            return "current_timestamp + interval '" + seconds + " second'";
        }

        @Override
        public boolean hasUpdateReturning() {
            return true;
        }

        @Override
        public boolean hasUpdateableCTE() {
            return true;
        }

        @Override
        public String nextActivationUpdate() {
            return "(case when ?::timestamptz is null then null when external_next_activation is null then ?::timestamptz else least(?::timestamptz, external_next_activation) end)";
        }

        @Override
        public String workflowStatus(WorkflowInstance.WorkflowInstanceStatus status) {
            return "'" + status.name() + "'::workflow_status";
        }

        @Override
        public String workflowStatus() {
            return "?::workflow_status";
        }

        @Override
        public String actionType() {
            return "?::action_type";
        }

        @Override
        public String castToText() {
            return "::text";
        }

        @Override
        public String limit(String query, long limit) {
            return query + " limit " + limit;
        }

        @Override
        public int longTextType() {
            return 12;
        }

        @Override
        public boolean useBatchUpdate() {
            return true;
        }

        @Override
        public String forUpdateSkipLocked() {
            return " for update skip locked";
        }
    }
}

