/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.config.db;

import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.internal.dao.DaoUtil;
import io.nflow.engine.internal.storage.db.SQLVariants;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;

@Profile(value={"nflow.db.sqlserver"})
@Configuration
public class SqlServerDatabaseConfiguration
extends DatabaseConfiguration {
    public SqlServerDatabaseConfiguration() {
        super("sqlserver");
    }

    @Override
    @Bean
    public SQLVariants sqlVariants(Environment env) {
        return new SQLServerVariants();
    }

    public static class SQLServerVariants
    implements SQLVariants {
        private static final Method getDateTimeOffsetMethod;
        private static final Method setDateTimeOffsetMethod;
        private static final Method getTimestampMethod;
        private static final Method createDateTimeOffsetMethod;
        private static final Class<?> sqlServerDateTimeOffset;
        private static final Class<?> sqlServerResultSet;
        private static final Class<?> sqlServerPreparedStatement;

        @Override
        public String currentTimePlusSeconds(int seconds) {
            return "dateadd(ss, " + seconds + ", current_timestamp)";
        }

        @Override
        public boolean hasUpdateableCTE() {
            return false;
        }

        @Override
        public String forUpdateSkipLocked() {
            return "";
        }

        @Override
        public String withUpdateSkipLocked() {
            return " with (updlock,readpast)";
        }

        @Override
        public String dateLtEqDiff(String next_activation, String current_timestamp) {
            return "datediff_big(ms, " + next_activation + ", " + current_timestamp + ") >= 0";
        }

        @Override
        public Object getTimestamp(ResultSet rs, String columnName) throws SQLException {
            try {
                return getDateTimeOffsetMethod.invoke(rs.unwrap(sqlServerResultSet), columnName);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SQLException("Failed to invoke getDateTimeOffset on ResultSet, column " + columnName, e);
            }
        }

        @Override
        public DateTime getDateTime(ResultSet rs, String columnName) throws SQLException {
            try {
                Object dateTimeOffset = getDateTimeOffsetMethod.invoke(rs.unwrap(sqlServerResultSet), columnName);
                if (dateTimeOffset == null) {
                    return null;
                }
                return DaoUtil.toDateTime((Timestamp)getTimestampMethod.invoke(dateTimeOffset, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SQLException("Failed to invoke getDateTimeOffset on column ResultSet, column " + columnName, e);
            }
        }

        @Override
        public void setDateTime(PreparedStatement ps, int columnNumber, DateTime timestamp) throws SQLException {
            try {
                setDateTimeOffsetMethod.invoke(ps.unwrap(sqlServerPreparedStatement), columnNumber, this.toTimestampObject(timestamp));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new SQLException("Failed to invoke setDateTimeOffset on PreparedStatement, columnNumber " + columnNumber, e);
            }
        }

        @Override
        public Object toTimestampObject(DateTime timestamp) {
            if (timestamp == null) {
                return null;
            }
            try {
                return createDateTimeOffsetMethod.invoke(null, DaoUtil.toTimestamp((BaseDateTime)timestamp), 0);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Failed to create DateTimeOffset instance, timestamp " + timestamp, e);
            }
        }

        @Override
        public String nextActivationUpdate() {
            return "(case when ? is null then null else iif(datediff_big(ms, ?, external_next_activation) > 0, external_next_activation, ?) end)";
        }

        @Override
        public String workflowStatus(WorkflowInstance.WorkflowInstanceStatus status) {
            return "'" + status.name() + "'";
        }

        @Override
        public String workflowStatus() {
            return "?";
        }

        @Override
        public String actionType() {
            return "?";
        }

        @Override
        public String castToText() {
            return "";
        }

        @Override
        public String limit(String query, long limit) {
            int idx = query.indexOf("select ");
            return query.substring(0, idx + 7) + "top(" + limit + ") " + query.substring(idx + 7);
        }

        @Override
        public int longTextType() {
            return 12;
        }

        @Override
        public boolean useBatchUpdate() {
            return true;
        }

        static {
            try {
                sqlServerDateTimeOffset = Class.forName("microsoft.sql.DateTimeOffset");
                sqlServerResultSet = Class.forName("com.microsoft.sqlserver.jdbc.ISQLServerResultSet");
                sqlServerPreparedStatement = Class.forName("com.microsoft.sqlserver.jdbc.ISQLServerPreparedStatement");
                getDateTimeOffsetMethod = sqlServerResultSet.getMethod("getDateTimeOffset", String.class);
                setDateTimeOffsetMethod = sqlServerPreparedStatement.getMethod("setDateTimeOffset", Integer.TYPE, sqlServerDateTimeOffset);
                getTimestampMethod = sqlServerDateTimeOffset.getMethod("getTimestamp", new Class[0]);
                createDateTimeOffsetMethod = sqlServerDateTimeOffset.getMethod("valueOf", Timestamp.class, Integer.TYPE);
            }
            catch (ClassNotFoundException | NoSuchMethodException e) {
                throw new RuntimeException("Could not find required getDateTimeOffset method from sqlserver jdbc driver", e);
            }
        }
    }
}

