/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.guice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.matcher.Matchers;
import io.nflow.engine.config.EngineConfiguration;
import io.nflow.engine.config.NFlow;
import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.config.db.Db2DatabaseConfiguration;
import io.nflow.engine.config.db.H2DatabaseConfiguration;
import io.nflow.engine.config.db.MariadbDatabaseConfiguration;
import io.nflow.engine.config.db.MysqlDatabaseConfiguration;
import io.nflow.engine.config.db.OracleDatabaseConfiguration;
import io.nflow.engine.config.db.PgDatabaseConfiguration;
import io.nflow.engine.config.db.SqlServerDatabaseConfiguration;
import io.nflow.engine.internal.executor.WorkflowInstanceExecutor;
import io.nflow.engine.internal.executor.WorkflowLifecycle;
import io.nflow.engine.internal.storage.db.DatabaseInitializer;
import io.nflow.engine.internal.storage.db.SQLVariants;
import java.sql.SQLException;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.h2.tools.Server;
import org.springframework.core.env.Environment;
import org.springframework.core.io.AbstractResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.transaction.support.TransactionTemplate;

public class EngineModule
extends AbstractModule {
    private final Object metricRegistry;
    private final EngineConfiguration engineConfiguration;
    private final DataSourceTransactionManager transactionManager = new GuiceDataSourceTransactionManager();

    public EngineModule(Object metricRegistry, EngineConfiguration engineConfiguration) {
        this.metricRegistry = metricRegistry;
        this.engineConfiguration = engineConfiguration;
    }

    protected void configure() {
        this.requestInjection(this.transactionManager);
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor((TransactionManager)this.transactionManager, (TransactionAttributeSource)new AnnotationTransactionAttributeSource());
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Transactional.class), new MethodInterceptor[]{transactionInterceptor});
        this.install((Module)new EngineInitModule());
    }

    @Provides
    @Inject
    @NFlow
    @Singleton
    public AbstractResource nflowNonSpringWorkflowsListing(Environment env) {
        return this.engineConfiguration.nflowNonSpringWorkflowsListing(env);
    }

    @Provides
    @NFlow
    @Singleton
    public ThreadFactory nflowThreadFactory() {
        return this.engineConfiguration.nflowThreadFactory();
    }

    @Provides
    @Inject
    @Singleton
    public WorkflowInstanceExecutor nflowExecutor(@NFlow ThreadFactory factory, Environment env) {
        return this.engineConfiguration.nflowExecutor(factory, env);
    }

    @Provides
    @NFlow
    @Singleton
    public ObjectMapper nflowObjectMapper() {
        return this.engineConfiguration.nflowObjectMapper();
    }

    @Provides
    @NFlow
    @Singleton
    public DataSource nflowDataSource(Environment env, DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.nflowDatasource(env, this.metricRegistry);
    }

    @Provides
    @NFlow
    @Singleton
    @Inject
    public DatabaseInitializer nflowDatabaseInitializer(@NFlow DataSource dataSource, Environment env, DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.nflowDatabaseInitializer(dataSource, env);
    }

    @Provides
    @NFlow
    @Singleton
    @Inject
    public JdbcTemplate nflowJdbcTemplate(@NFlow DataSource dataSource, DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.nflowJdbcTemplate(dataSource);
    }

    @Provides
    @NFlow
    @Singleton
    @Inject
    public NamedParameterJdbcTemplate nflowNamedParameterJdbcTemplate(@NFlow DataSource dataSource, DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.nflowNamedParameterJdbcTemplate(dataSource);
    }

    @Provides
    @NFlow
    @Singleton
    @Inject
    public TransactionTemplate nflowTransactionTemplate(@NFlow DataSourceTransactionManager txManager, DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.nflowTransactionTemplate((PlatformTransactionManager)txManager);
    }

    @Provides
    @NFlow
    @Singleton
    public DataSourceTransactionManager nflowPlatformTransactionManager() {
        return this.transactionManager;
    }

    @Provides
    @Singleton
    @Inject
    public SQLVariants nflowSQLVariants(Environment env, DatabaseConfiguration databaseConfiguration) {
        return databaseConfiguration.sqlVariants(env);
    }

    @Provides
    @Singleton
    @Inject
    public DatabaseConfiguration databaseConfiguration(Environment env) {
        String dbtype;
        switch (dbtype = (String)env.getRequiredProperty("nflow.db.type", String.class)) {
            case "db2": {
                return new Db2DatabaseConfiguration();
            }
            case "h2": {
                return new H2DatabaseConfiguration();
            }
            case "mariadb": {
                return new MariadbDatabaseConfiguration();
            }
            case "mysql": {
                return new MysqlDatabaseConfiguration();
            }
            case "oracle": {
                return new OracleDatabaseConfiguration();
            }
            case "postgresql": {
                return new PgDatabaseConfiguration();
            }
            case "sqlserver": {
                return new SqlServerDatabaseConfiguration();
            }
        }
        throw new RuntimeException("Unknown database type " + dbtype);
    }

    static class EngineInitModule
    extends AbstractModule {
        EngineInitModule() {
        }

        protected void configure() {
            this.requestInjection((Object)this);
        }

        @Inject
        void initLifeCycleAutoStart(WorkflowLifecycle lifecycle) {
            if (lifecycle.isAutoStartup()) {
                lifecycle.start();
            }
        }

        @Inject
        void initH2TcpServer(Environment env, DatabaseConfiguration databaseConfiguration) throws SQLException {
            Server server;
            if (databaseConfiguration instanceof H2DatabaseConfiguration && (server = ((H2DatabaseConfiguration)databaseConfiguration).h2TcpServer(env)) != null) {
                server.start();
            }
        }

        @Inject
        void initH2ConsoleServer(Environment env, DatabaseConfiguration databaseConfiguration) throws SQLException {
            Server server;
            if (databaseConfiguration instanceof H2DatabaseConfiguration && (server = ((H2DatabaseConfiguration)databaseConfiguration).h2ConsoleServer(env)) != null) {
                server.start();
            }
        }
    }

    static class GuiceDataSourceTransactionManager
    extends DataSourceTransactionManager {
        private static final long serialVersionUID = 1L;

        GuiceDataSourceTransactionManager() {
        }

        @Inject
        public void setDatasource(@NFlow DataSource dataSource) {
            super.setDataSource(dataSource);
        }
    }
}

