/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.guice;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.executor.WorkflowLifecycle;
import io.nflow.engine.internal.workflow.MaintenanceWorkflowStarter;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NflowController {
    private final WorkflowLifecycle lifecycle;
    private final WorkflowDefinitionService workflowDefinitionService;
    private final MaintenanceWorkflowStarter maintenanceWorkflowStarter;
    private final Set<WorkflowDefinition> workflows;

    @Inject
    public NflowController(WorkflowLifecycle lifecycle, WorkflowDefinitionService workflowDefinitionService, MaintenanceWorkflowStarter maintenanceWorkflowStarter, Set<WorkflowDefinition> workflowDefinitions) {
        this.lifecycle = lifecycle;
        this.workflowDefinitionService = workflowDefinitionService;
        this.maintenanceWorkflowStarter = maintenanceWorkflowStarter;
        this.workflows = workflowDefinitions;
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="RuntimeException message is ok")
    public void start() {
        try {
            this.workflows.forEach(this.workflowDefinitionService::addWorkflowDefinition);
            this.maintenanceWorkflowStarter.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to register workflows", e);
        }
        this.lifecycle.start();
    }

    public void stop() {
        this.lifecycle.stop();
    }
}

