/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.dao;

import io.nflow.engine.config.NFlow;
import io.nflow.engine.internal.dao.DaoUtil;
import io.nflow.engine.internal.dao.ExecutorDao;
import io.nflow.engine.internal.dao.NflowTable;
import io.nflow.engine.internal.dao.TableType;
import io.nflow.engine.internal.storage.db.SQLVariants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.transaction.annotation.Transactional;

@Named
public class MaintenanceDao {
    private static final Logger logger = LoggerFactory.getLogger(MaintenanceDao.class);
    private final SQLVariants sqlVariants;
    private final JdbcTemplate jdbc;
    private final ExecutorDao executorDao;
    private final NamedParameterJdbcTemplate namedJdbc;
    private String workflowColumns;
    private String actionColumns;
    private String stateColumns;

    @Inject
    public MaintenanceDao(SQLVariants sqlVariants, @NFlow JdbcTemplate jdbcTemplate, ExecutorDao executorDao, @NFlow NamedParameterJdbcTemplate nflowNamedParameterJdbcTemplate) {
        this.sqlVariants = sqlVariants;
        this.jdbc = jdbcTemplate;
        this.executorDao = executorDao;
        this.namedJdbc = nflowNamedParameterJdbcTemplate;
    }

    private String getWorkflowColumns() {
        if (StringUtils.isBlank((CharSequence)this.workflowColumns)) {
            this.workflowColumns = this.columnsFromMetadata("nflow_workflow");
        }
        return this.workflowColumns;
    }

    private String getActionColumns() {
        if (StringUtils.isBlank((CharSequence)this.actionColumns)) {
            this.actionColumns = this.columnsFromMetadata("nflow_workflow_action");
        }
        return this.actionColumns;
    }

    private String getStateColumns() {
        if (StringUtils.isBlank((CharSequence)this.stateColumns)) {
            this.stateColumns = this.columnsFromMetadata("nflow_workflow_state");
        }
        return this.stateColumns;
    }

    public List<Long> getOldWorkflowIds(TableType type, DateTime before, int maxWorkflows, Set<String> workflowTypes) {
        StringBuilder sql = new StringBuilder("select id from ").append(NflowTable.WORKFLOW.tableFor(type)).append(" where ").append(this.executorDao.getExecutorGroupCondition()).append(" and next_activation is null and ").append(this.sqlVariants.dateLtEqDiff("modified", "?"));
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.sqlVariants.toTimestampObject(before));
        if (!workflowTypes.isEmpty()) {
            sql.append(" and type in (").append(Stream.generate(() -> "?").limit(workflowTypes.size()).collect(Collectors.joining(","))).append(')');
            args.addAll(workflowTypes);
        }
        sql.append(" order by id asc");
        return this.jdbc.queryForList(this.sqlVariants.limit(sql.toString(), maxWorkflows), Long.class, args.toArray(new Object[0]));
    }

    @Transactional
    public int archiveWorkflows(Collection<Long> workflowIds) {
        String workflowIdParams = this.params(workflowIds);
        int archivedInstances = this.archiveTable(NflowTable.WORKFLOW, "id", this.getWorkflowColumns(), workflowIdParams);
        int archivedActions = this.archiveTable(NflowTable.ACTION, "workflow_id", this.getActionColumns(), workflowIdParams);
        int archivedStates = this.archiveTable(NflowTable.STATE, "workflow_id", this.getStateColumns(), workflowIdParams);
        logger.info("Archived {} workflow instances, {} actions and {} states.", new Object[]{archivedInstances, archivedActions, archivedStates});
        this.deleteWorkflows(TableType.MAIN, workflowIdParams);
        return archivedInstances;
    }

    @Transactional
    public int deleteWorkflows(TableType type, Collection<Long> workflowIds) {
        String workflowIdParams = this.params(workflowIds);
        return this.deleteWorkflows(type, workflowIdParams);
    }

    private int archiveTable(NflowTable table, String workflowIdColumn, String columns, String workflowIdParams) {
        return this.jdbc.update("insert into " + table.archive + "(" + columns + ") select " + columns + " from " + table.main + this.sqlVariants.withUpdateSkipLocked() + " where " + workflowIdColumn + " in " + workflowIdParams + this.sqlVariants.forUpdateSkipLocked());
    }

    private int deleteWorkflows(TableType type, String workflowIdParams) {
        int deletedStates = this.jdbc.update("delete from " + NflowTable.STATE.tableFor(type) + " where workflow_id in " + workflowIdParams);
        int deletedActions = this.jdbc.update("delete from " + NflowTable.ACTION.tableFor(type) + " where workflow_id in " + workflowIdParams);
        int deletedInstances = this.jdbc.update("delete from " + NflowTable.WORKFLOW.tableFor(type) + " where id in " + workflowIdParams);
        logger.info("Deleted {} workflow instances, {} actions and {} states from {} tables.", new Object[]{deletedInstances, deletedActions, deletedStates, type.name()});
        return deletedInstances;
    }

    private String columnsFromMetadata(String tableName) {
        List columnNames = (List)this.jdbc.query("select * from " + tableName + " where 1 = 0", (ResultSetExtractor)DaoUtil.ColumnNamesExtractor.columnNamesExtractor);
        return StringUtils.join((Iterable)columnNames, (String)",");
    }

    private String params(Collection<Long> workflowIds) {
        return "(" + StringUtils.join(workflowIds, (String)",") + ")";
    }

    @Transactional
    public void deleteActionAndStateHistory(long workflowInstanceId, DateTime olderThan) {
        long start = System.currentTimeMillis();
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("workflowId", (Object)workflowInstanceId);
        params.addValue("olderThan", this.sqlVariants.toTimestampObject(olderThan));
        Long maxActionId = (Long)this.namedJdbc.queryForObject("select max(id) from nflow_workflow_action where workflow_id = :workflowId and " + this.sqlVariants.dateLtEqDiff("execution_end", ":olderThan"), (SqlParameterSource)params, Long.class);
        int deletedStates = 0;
        int deletedActions = 0;
        if (maxActionId != null) {
            params.addValue("maxActionId", (Object)maxActionId);
            List referredActionIds = this.namedJdbc.queryForList("select distinct(max(action_id)) from nflow_workflow_state where workflow_id = :workflowId group by state_key", (SqlParameterSource)params, Long.class);
            String deleteStates = "delete from nflow_workflow_state where workflow_id = :workflowId and action_id <= :maxActionId";
            if (referredActionIds.isEmpty()) {
                deletedStates = this.namedJdbc.update(deleteStates, (SqlParameterSource)params);
            } else {
                params.addValue("referredActionIds", (Object)referredActionIds);
                deletedStates = this.namedJdbc.update(deleteStates + " and action_id not in (:referredActionIds)", (SqlParameterSource)params);
            }
            referredActionIds.addAll(this.namedJdbc.queryForList("select distinct parent_action_id from nflow_workflow where parent_workflow_id = :workflowId", (SqlParameterSource)params, Long.class));
            String deleteActions = "delete from nflow_workflow_action where workflow_id = :workflowId and id <= :maxActionId";
            if (referredActionIds.isEmpty()) {
                deletedActions = this.namedJdbc.update(deleteActions, (SqlParameterSource)params);
            } else {
                params.addValue("referredActionIds", (Object)referredActionIds);
                deletedActions = this.namedJdbc.update(deleteActions + " and id not in (:referredActionIds)", (SqlParameterSource)params);
            }
        }
        if (deletedActions > 0 || deletedStates > 0) {
            logger.info("Deleted {} actions and {} states from workflow instance {} that were older than {}. Took {} ms.", new Object[]{deletedActions, deletedStates, workflowInstanceId, olderThan, System.currentTimeMillis() - start});
        }
    }
}

