/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.executor;

import io.nflow.engine.exception.StateSaveExceptionAnalyzer;
import io.nflow.engine.internal.dao.MaintenanceDao;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.internal.executor.WorkflowStateProcessor;
import io.nflow.engine.internal.util.NflowLogger;
import io.nflow.engine.internal.workflow.ObjectStringMapper;
import io.nflow.engine.internal.workflow.WorkflowInstancePreProcessor;
import io.nflow.engine.listener.WorkflowExecutorListener;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.engine.service.WorkflowInstanceService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class WorkflowStateProcessorFactory {
    private final WorkflowDefinitionService workflowDefinitions;
    private final WorkflowInstanceService workflowInstances;
    private final ObjectStringMapper objectMapper;
    private final WorkflowInstanceDao workflowInstanceDao;
    private final MaintenanceDao maintenanceDao;
    private final WorkflowInstancePreProcessor workflowInstancePreProcessor;
    private final NflowLogger nflowLogger;
    private final StateSaveExceptionAnalyzer stateSaveExceptionAnalyzer;
    private final Environment env;
    @Autowired(required=false)
    protected WorkflowExecutorListener[] listeners = new WorkflowExecutorListener[0];
    final Map<Long, WorkflowStateProcessor> processingInstances = new ConcurrentHashMap<Long, WorkflowStateProcessor>();
    private final int stuckThreadThresholdSeconds;

    @Inject
    public WorkflowStateProcessorFactory(WorkflowDefinitionService workflowDefinitions, WorkflowInstanceService workflowInstances, ObjectStringMapper objectMapper, WorkflowInstanceDao workflowInstanceDao, MaintenanceDao maintenanceDao, WorkflowInstancePreProcessor workflowInstancePreProcessor, NflowLogger nflowLogger, StateSaveExceptionAnalyzer stateSaveExceptionAnalyzer, Environment env) {
        this.workflowDefinitions = workflowDefinitions;
        this.workflowInstances = workflowInstances;
        this.objectMapper = objectMapper;
        this.workflowInstanceDao = workflowInstanceDao;
        this.maintenanceDao = maintenanceDao;
        this.workflowInstancePreProcessor = workflowInstancePreProcessor;
        this.nflowLogger = nflowLogger;
        this.stateSaveExceptionAnalyzer = stateSaveExceptionAnalyzer;
        this.stuckThreadThresholdSeconds = (Integer)env.getRequiredProperty("nflow.executor.stuckThreadThreshold.seconds", Integer.class);
        this.env = env;
    }

    public WorkflowStateProcessor createProcessor(long instanceId, Supplier<Boolean> shutdownRequested) {
        return new WorkflowStateProcessor(instanceId, shutdownRequested, this.objectMapper, this.workflowDefinitions, this.workflowInstances, this.workflowInstanceDao, this.maintenanceDao, this.workflowInstancePreProcessor, this.env, this.processingInstances, this.nflowLogger, this.stateSaveExceptionAnalyzer, this.listeners);
    }

    public int getPotentiallyStuckProcessors() {
        DateTime currentTime = DateTime.now();
        int potentiallyStuck = 0;
        for (WorkflowStateProcessor processor : this.processingInstances.values()) {
            Duration processingTime = new Duration((ReadableInstant)processor.getStartTime(), (ReadableInstant)currentTime);
            long processingTimeSeconds = processingTime.getStandardSeconds();
            if (processingTimeSeconds <= (long)this.stuckThreadThresholdSeconds) continue;
            ++potentiallyStuck;
            processor.logPotentiallyStuck(processingTimeSeconds);
            processor.handlePotentiallyStuck(processingTime);
        }
        return potentiallyStuck;
    }
}

