/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.internal.storage.db;

import java.nio.charset.StandardCharsets;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.jdbc.datasource.init.ScriptStatementFailedException;

public class DatabaseInitializer {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseInitializer.class);

    public DatabaseInitializer(String dbType, DataSource ds, Environment env, String scriptSeparator) {
        if (!((Boolean)env.getRequiredProperty("nflow.db.create_on_startup", Boolean.class)).booleanValue()) {
            return;
        }
        this.populate(dbType, scriptSeparator, ds);
    }

    private void populate(String dbType, String scriptSeparator, DataSource ds) {
        ResourceDatabasePopulator populator = this.createPopulator(dbType, scriptSeparator);
        try {
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)ds);
            logger.info("Database created.");
        }
        catch (ScriptStatementFailedException ex) {
            logger.warn("Failed to create the database, possibly already created: {}", (Object)ex.getMessage());
            logger.debug("Failed to create the database", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.warn("Failed to create the database", (Throwable)ex);
        }
    }

    private ResourceDatabasePopulator createPopulator(String dbType, String scriptSeparator) {
        ClassPathResource script = this.resolveScript(dbType);
        logger.info("Creating database populator using script '{}'", (Object)script.getPath());
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setSeparator(scriptSeparator);
        populator.setIgnoreFailedDrops(true);
        populator.setSqlScriptEncoding(StandardCharsets.UTF_8.name());
        populator.addScript((Resource)script);
        return populator;
    }

    private ClassPathResource resolveScript(String dbType) {
        ClassPathResource script = new ClassPathResource("scripts/db/" + dbType + ".create.ddl.sql");
        if (!script.exists()) {
            throw new IllegalArgumentException("No ddl script found: " + script);
        }
        return script;
    }
}

