/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.joda.time.ReadablePeriod;
import org.springframework.util.Assert;

public class MaintenanceConfiguration {
    public final ConfigurationItem archiveWorkflows;
    public final ConfigurationItem deleteArchivedWorkflows;
    public final ConfigurationItem deleteWorkflows;

    MaintenanceConfiguration(@JsonProperty(value="deleteArchivedWorkflows") ConfigurationItem deleteArchivedWorkflows, @JsonProperty(value="archiveWorkflows") ConfigurationItem archiveWorkflows, @JsonProperty(value="deleteWorkflows") ConfigurationItem deleteWorkflows) {
        this.deleteArchivedWorkflows = deleteArchivedWorkflows;
        this.archiveWorkflows = archiveWorkflows;
        this.deleteWorkflows = deleteWorkflows;
    }

    public static class ConfigurationItem {
        public final ReadablePeriod olderThanPeriod;
        public final int batchSize;
        public final Set<String> workflowTypes;

        ConfigurationItem(@JsonProperty(value="olderThanPeriod") ReadablePeriod olderThanPeriod, @JsonProperty(value="batchSize") Integer batchSize, @JsonProperty(value="workflowTypes") Set<String> workflowTypes) {
            this.olderThanPeriod = olderThanPeriod;
            this.batchSize = batchSize;
            this.workflowTypes = Optional.ofNullable(workflowTypes).orElseGet(Collections::emptySet);
        }

        public static class Builder {
            private final io.nflow.engine.service.MaintenanceConfiguration$Builder parentBuilder;
            private ReadablePeriod olderThanPeriod;
            private Integer batchSize = 1000;
            private Set<String> workflowTypes = Collections.emptySet();

            Builder(io.nflow.engine.service.MaintenanceConfiguration$Builder parentBuilder) {
                this.parentBuilder = parentBuilder;
            }

            public Builder setOlderThanPeriod(ReadablePeriod olderThanPeriod) {
                this.olderThanPeriod = olderThanPeriod;
                return this;
            }

            public Builder setBatchSize(int batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder setWorkflowTypes(Set<String> workflowTypes) {
                this.workflowTypes = workflowTypes;
                return this;
            }

            public io.nflow.engine.service.MaintenanceConfiguration$Builder done() {
                return this.parentBuilder;
            }

            ConfigurationItem build() {
                Assert.isTrue((this.olderThanPeriod != null ? 1 : 0) != 0, (String)"olderThanPeriod must not be null");
                Assert.isTrue((this.batchSize > 0 ? 1 : 0) != 0, (String)"batchSize must be greater than 0");
                Assert.isTrue((this.workflowTypes != null ? 1 : 0) != 0, (String)"workflowTypes must not be null");
                return new ConfigurationItem(this.olderThanPeriod, this.batchSize, this.workflowTypes);
            }
        }
    }

    public static class Builder {
        private ConfigurationItem.Builder deleteArchivedWorkflows;
        private ConfigurationItem.Builder archiveWorkflows;
        private ConfigurationItem.Builder deleteWorkflows;

        public ConfigurationItem.Builder withArchiveWorkflows() {
            this.archiveWorkflows = new ConfigurationItem.Builder(this);
            return this.archiveWorkflows;
        }

        public ConfigurationItem.Builder withDeleteArchivedWorkflows() {
            this.deleteArchivedWorkflows = new ConfigurationItem.Builder(this);
            return this.deleteArchivedWorkflows;
        }

        public ConfigurationItem.Builder withDeleteWorkflows() {
            this.deleteWorkflows = new ConfigurationItem.Builder(this);
            return this.deleteWorkflows;
        }

        private ConfigurationItem build(ConfigurationItem.Builder builder) {
            return Optional.ofNullable(builder).map(ConfigurationItem.Builder::build).orElse(null);
        }

        public MaintenanceConfiguration build() {
            return new MaintenanceConfiguration(this.build(this.deleteArchivedWorkflows), this.build(this.archiveWorkflows), this.build(this.deleteWorkflows));
        }
    }
}

