/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.engine.service;

import io.nflow.engine.internal.dao.WorkflowDefinitionDao;
import io.nflow.engine.workflow.definition.WorkflowDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Singleton
public class WorkflowDefinitionService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowDefinitionService.class);
    private final Map<String, WorkflowDefinition> workflowDefinitions = Collections.synchronizedMap(new LinkedHashMap());
    private List<WorkflowDefinition> workflowDefinitionValues = Collections.emptyList();
    private final WorkflowDefinitionDao workflowDefinitionDao;
    private final boolean persistWorkflowDefinitions;
    private final boolean autoInit;

    @Inject
    public WorkflowDefinitionService(WorkflowDefinitionDao workflowDefinitionDao, Environment env) {
        this.workflowDefinitionDao = workflowDefinitionDao;
        this.persistWorkflowDefinitions = (Boolean)env.getRequiredProperty("nflow.definition.persist", Boolean.class);
        this.autoInit = (Boolean)env.getRequiredProperty("nflow.autoinit", Boolean.class);
    }

    public WorkflowDefinition getWorkflowDefinition(String type) {
        return this.workflowDefinitions.get(type);
    }

    public List<WorkflowDefinition> getWorkflowDefinitions() {
        return this.workflowDefinitionValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postProcessWorkflowDefinitions() {
        if (!this.autoInit && this.persistWorkflowDefinitions) {
            Map<String, WorkflowDefinition> map = this.workflowDefinitions;
            synchronized (map) {
                this.workflowDefinitions.values().forEach(this.workflowDefinitionDao::storeWorkflowDefinition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkflowDefinition(WorkflowDefinition wd) {
        WorkflowDefinition conflict = this.workflowDefinitions.put(wd.getType(), wd);
        if (conflict != null) {
            throw new IllegalStateException("Both " + wd.getClass().getName() + " and " + conflict.getClass().getName() + " define same workflow type: " + wd.getType());
        }
        if (this.autoInit && this.persistWorkflowDefinitions) {
            this.workflowDefinitionDao.storeWorkflowDefinition(wd);
        }
        Map<String, WorkflowDefinition> map = this.workflowDefinitions;
        synchronized (map) {
            this.workflowDefinitionValues = new ArrayList<WorkflowDefinition>(this.workflowDefinitions.values());
        }
        logger.info("Added workflow type: {} ({})", (Object)wd.getType(), (Object)wd.getClass().getName());
    }
}

