/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.server.spring;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.support.ResourcePropertySource;

public class NflowStandardEnvironment
extends StandardEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(NflowStandardEnvironment.class);

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="addExternalPropertyResource and setupDbProfile are private")
    public NflowStandardEnvironment(Map<String, Object> overrideProperties) {
        this.getPropertySources().addFirst((PropertySource)new MapPropertySource("override", overrideProperties));
        this.addExternalPropertyResource();
        String env = this.getProperty("env", "local");
        this.addPropertyResource(env);
        this.addPropertyResource("common");
        this.addPropertyResource("nflow-server");
        Boolean clearProfiles = (Boolean)this.getProperty("clearProfiles", Boolean.class, Boolean.FALSE);
        if (clearProfiles.booleanValue()) {
            this.setActiveProfiles(new String[]{"ignore-environment-profiles"});
        }
        this.addActiveProfile(env);
        String profiles = (String)this.getProperty("profiles", String.class, "");
        for (String profile : profiles.split(",")) {
            if (profile.trim().isEmpty()) continue;
            this.addActiveProfile(profile);
        }
        this.setupDbProfile();
    }

    private void setupDbProfile() {
        Object[] activeProfiles;
        boolean dbProfileDefined = false;
        for (String string : activeProfiles = this.getActiveProfiles()) {
            if (!string.startsWith("nflow.db")) continue;
            if (dbProfileDefined) {
                throw new RuntimeException("Multiple nflow.db profiles defined: " + Arrays.toString(activeProfiles));
            }
            dbProfileDefined = true;
        }
        if (!dbProfileDefined) {
            this.addActiveProfile("nflow.db.h2");
        }
    }

    private void addExternalPropertyResource() {
        String externalLocation = this.getProperty("nflow.external.config");
        if (!StringUtils.isEmpty((CharSequence)externalLocation)) {
            try {
                this.getPropertySources().addLast((PropertySource)new ResourcePropertySource(externalLocation));
                logger.info("Using external configuration file: {}", (Object)externalLocation);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to initialize external properties from location " + externalLocation, e);
            }
        }
    }

    private void addPropertyResource(String name) {
        name = (String)name + ".properties";
        try {
            this.getPropertySources().addLast((PropertySource)new ResourcePropertySource((String)name, ((Object)((Object)this)).getClass().getClassLoader()));
        }
        catch (IOException e) {
            logger.info("Failed to initialize environment-specific properties from resource {}", name);
        }
    }
}

