/*
 * Decompiled with CFR 0.152.
 */
package io.ningyuan.jPdbApi;

import com.google.gson.Gson;
import io.ningyuan.jPdbApi.JsonEntryResults;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class Pdb {
    private static final String GET_ENTRY_BY_ID_URL = "https://data.rcsb.org/rest/v1/core/entry/%s";
    private static final String DOWNLOAD_BY_ID_URL = "https://files.rcsb.org/download/%s.pdb";
    private String structureId;
    private String title;

    public Pdb(String structureId) {
        this.structureId = structureId;
    }

    public void load() throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(String.format(GET_ENTRY_BY_ID_URL, this.structureId)).get().build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            JsonEntryResults results = (JsonEntryResults)new Gson().fromJson(response.body().string(), JsonEntryResults.class);
            this.title = results.struct.title.trim();
        }
    }

    public InputStream getInputStream() throws IOException {
        URL url = new URL(String.format(DOWNLOAD_BY_ID_URL, this.structureId));
        URLConnection connection = url.openConnection();
        return connection.getInputStream();
    }

    public String getStructureId() {
        return this.structureId;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return String.format("[%s] %s", this.getStructureId(), this.getTitle());
    }
}

