/*
 * Decompiled with CFR 0.152.
 */
package io.ningyuan.jPdbApi;

import com.google.gson.Gson;
import io.ningyuan.jPdbApi.JsonParameters;
import io.ningyuan.jPdbApi.JsonQuery;
import io.ningyuan.jPdbApi.JsonRequestOptions;
import io.ningyuan.jPdbApi.JsonResults;
import java.io.IOException;
import java.util.Arrays;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TextSearch {
    public String value;
    public int pageSize = 25;
    public int pageCursor = 0;
    private JsonParameters payload;
    private final String ENDPOINT = "https://search.rcsb.org/rcsbsearch/v1/query";
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");

    public TextSearch(String value) {
        this.value = value;
        this.payload = new JsonParameters();
        this.payload.query = new JsonQuery(value);
        this.payload.request_options = new JsonRequestOptions(this.pageCursor, this.pageSize);
        this.payload.return_type = "entry";
    }

    public TextSearch(String value, int pageSize) {
        this(value);
        this.pageSize = pageSize;
        this.payload.request_options = new JsonRequestOptions(this.pageCursor, this.pageSize);
    }

    public String[] getPage() throws IOException {
        OkHttpClient client = new OkHttpClient();
        RequestBody jsonPayload = RequestBody.create((String)new Gson().toJson((Object)this.payload), (MediaType)JSON);
        Request request = new Request.Builder().url(this.ENDPOINT).post(jsonPayload).build();
        try (Response response = client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("Unexpected code " + response);
            }
            JsonResults results = (JsonResults)new Gson().fromJson(response.body().string(), JsonResults.class);
            String[] stringArray = (String[])Arrays.stream(results.result_set).map(r -> r.identifier).toArray(String[]::new);
            return stringArray;
        }
    }

    public void nextPage() {
        this.pageCursor += this.pageSize;
        this.payload.request_options = new JsonRequestOptions(this.pageCursor, this.pageSize);
    }
}

