/*
 * Decompiled with CFR 0.152.
 */
package io.nity.grpc.client.channel.factory;

import io.grpc.inprocess.InProcessChannelBuilder;
import io.nity.grpc.client.channel.configurer.GrpcChannelBuilderConfigurer;
import io.nity.grpc.client.channel.configurer.GrpcChannelConfigurer;
import io.nity.grpc.client.channel.factory.AbstractChannelFactory;
import io.nity.grpc.client.config.GrpcClientProperties;
import io.nity.grpc.client.config.GrpcClientPropertiesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class InProcessChannelFactory
extends AbstractChannelFactory<InProcessChannelBuilder> {
    private static final Logger log = LoggerFactory.getLogger(InProcessChannelFactory.class);

    public InProcessChannelFactory(GrpcClientPropertiesMap clientPropertiesMap, GrpcChannelBuilderConfigurer channelBuilderConfigurer, GrpcChannelConfigurer channelConfigurer) {
        super(clientPropertiesMap, channelBuilderConfigurer, channelConfigurer);
    }

    @Override
    protected InProcessChannelBuilder newChannelBuilder(String name, GrpcClientProperties clientProperties) {
        log.debug("Creating new channel: {}", (Object)clientProperties);
        String inProcessServerName = clientProperties.getInProcessServerName();
        if (!StringUtils.hasText((String)inProcessServerName)) {
            log.error("please config required property [inProcessServerName] for InProcess model");
            throw new RuntimeException("Failed to create inProcessChannel");
        }
        log.warn("will create InProcessChannel. Please only use in testing");
        return InProcessChannelBuilder.forName((String)inProcessServerName);
    }
}

