/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules.ktlint;

import io.nlopez.compose.core.ComposeKtConfig;
import io.nlopez.compose.core.ComposeKtVisitor;
import io.nlopez.compose.core.Emitter;
import io.nlopez.compose.rules.KtlintRule;
import io.nlopez.compose.rules.UnstableCollections;
import io.nlopez.compose.rules.ktlint.EditorConfigPropertiesKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/nlopez/compose/rules/ktlint/UnstableCollectionsCheck;", "Lio/nlopez/compose/rules/KtlintRule;", "Lio/nlopez/compose/core/ComposeKtVisitor;", "<init>", "()V", "visitor", "Lio/nlopez/compose/rules/UnstableCollections;", "visitComposable", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "autoCorrect", "", "emitter", "Lio/nlopez/compose/core/Emitter;", "config", "Lio/nlopez/compose/core/ComposeKtConfig;", "ktlint"})
public final class UnstableCollectionsCheck
extends KtlintRule
implements ComposeKtVisitor {
    @NotNull
    private final UnstableCollections visitor = new UnstableCollections();

    public UnstableCollectionsCheck() {
        super("compose:unstable-collections", SetsKt.setOf(EditorConfigPropertiesKt.getDisallowUnstableCollections()));
    }

    public void visitComposable(@NotNull KtFunction function, boolean autoCorrect, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getBoolean("disallowUnstableCollections", false)) {
            this.visitor.visitComposable(function, autoCorrect, emitter, config);
        }
    }
}

