/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.automatter.jackson;

import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.NopAnnotationIntrospector;
import io.norberg.automatter.AutoMatter;

class AutoMatterAnnotationIntrospector
extends NopAnnotationIntrospector {
    AutoMatterAnnotationIntrospector() {
    }

    public String findImplicitPropertyName(AnnotatedMember member) {
        AutoMatter.Field field = (AutoMatter.Field)member.getAnnotation(AutoMatter.Field.class);
        if (field == null) {
            return null;
        }
        if (member instanceof AnnotatedParameter) {
            return field.value();
        }
        if (member instanceof AnnotatedMethod) {
            return member.getName();
        }
        return null;
    }

    public boolean hasCreatorAnnotation(Annotated a) {
        if (!(a instanceof AnnotatedConstructor)) {
            return false;
        }
        AnnotatedConstructor ctor = (AnnotatedConstructor)a;
        if (ctor.getParameterCount() == 0) {
            return true;
        }
        AutoMatter.Field field = (AutoMatter.Field)ctor.getParameter(0).getAnnotation(AutoMatter.Field.class);
        return field != null;
    }
}

