/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.automatter.jackson;

import com.fasterxml.jackson.databind.AbstractTypeResolver;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import io.norberg.automatter.AutoMatter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class AutoMatterResolver
extends AbstractTypeResolver {
    private static final String VALUE_SUFFIX = "Builder$Value";
    private final ConcurrentMap<JavaType, JavaType> types = new ConcurrentHashMap<JavaType, JavaType>();

    AutoMatterResolver() {
    }

    public JavaType resolveAbstractType(DeserializationConfig config, JavaType type) {
        Class<?> cls;
        Class rawClass = type.getRawClass();
        AutoMatter annotation = rawClass.getAnnotation(AutoMatter.class);
        if (annotation == null) {
            return super.resolveAbstractType(config, type);
        }
        JavaType cached = (JavaType)this.types.get(type);
        if (cached != null) {
            return cached;
        }
        String packageName = rawClass.getPackage().getName();
        String name = rawClass.getSimpleName();
        String valueName = packageName + '.' + name + VALUE_SUFFIX;
        try {
            cls = Class.forName(valueName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No builder found for @AutoMatter type: " + name, e);
        }
        SimpleType materialized = SimpleType.construct(cls);
        JavaType existing = this.types.putIfAbsent(type, (JavaType)materialized);
        return existing != null ? existing : materialized;
    }
}

