/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.rut;

import io.norberg.rut.CharSequences;
import io.norberg.rut.Objects;
import io.norberg.rut.ParameterType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class Path {
    private final List<Part> parts;
    private final List<String> captureNames;
    private final List<ParameterType> captureParameterTypes;
    private final String string;

    Path(List<Part> parts) {
        this.parts = Objects.requireNonNull(parts, "parts", new Object[0]);
        if (parts.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> captureNames = new ArrayList<String>();
        ArrayList<ParameterType> parameterTypes = new ArrayList<ParameterType>();
        for (Part part : parts) {
            if (!(part instanceof Capture)) continue;
            captureNames.add(((Capture)part).name());
            if (part instanceof CaptureSegment) {
                parameterTypes.add(ParameterType.SEGMENT);
                continue;
            }
            parameterTypes.add(ParameterType.PATH);
        }
        this.captureNames = Collections.unmodifiableList(captureNames);
        this.captureParameterTypes = Collections.unmodifiableList(parameterTypes);
        this.string = Path.join(parts);
    }

    List<Part> parts() {
        return this.parts;
    }

    List<String> captureNames() {
        return this.captureNames;
    }

    public String toString() {
        return this.string;
    }

    static Path of(CharSequence path) {
        return Path.of(path.toString());
    }

    static Path of(String path) {
        return new Path(Path.parts(path));
    }

    public List<ParameterType> captureParameterTypes() {
        return this.captureParameterTypes;
    }

    private static List<Part> parts(String path) {
        if (path.isEmpty()) {
            throw new IllegalArgumentException("Empty path");
        }
        ArrayList<Part> parts = new ArrayList<Part>();
        State state = State.PREFIX;
        int start = 0;
        block4: for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c > '\u007f') {
                throw new IllegalArgumentException();
            }
            switch (state) {
                case PREFIX: {
                    if (c != '<') continue block4;
                    if (i != start) {
                        parts.add(new Match(path.substring(start, i)));
                    }
                    start = i + 1;
                    state = State.CAPTURE;
                    continue block4;
                }
                case CAPTURE: {
                    if (c != '>') continue block4;
                    Capture capture = Path.capture(path, start, i);
                    if (capture instanceof CapturePath && path.length() > i + 1) {
                        throw new IllegalArgumentException("path capture must be last");
                    }
                    parts.add(capture);
                    start = i + 1;
                    state = State.PREFIX;
                }
            }
        }
        if (state == State.CAPTURE) {
            throw new IllegalArgumentException("unclosed capture: " + path);
        }
        if (start < path.length()) {
            parts.add(new Match(path.substring(start)));
        }
        return parts;
    }

    private static Capture capture(String path, int start, int end) {
        int colon = CharSequences.indexOf(path, ':', start + 1, end);
        if (colon == -1) {
            return new CaptureSegment(path.substring(start, end));
        }
        String name = path.subSequence(start, colon).toString();
        String type = path.subSequence(colon + 1, end).toString();
        if ("path".equals(type)) {
            return new CapturePath(name);
        }
        throw new IllegalArgumentException("Unknown capture type: " + name);
    }

    private static String join(List<Part> parts) {
        StringBuilder b = new StringBuilder();
        for (Part part : parts) {
            b.append(part.toString());
        }
        return b.toString();
    }

    private static enum State {
        PREFIX,
        CAPTURE;

    }

    static final class CapturePath
    implements Capture {
        private final String name;

        CapturePath(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return "<" + this.name + ":path>";
        }
    }

    static final class CaptureSegment
    implements Capture {
        private final String name;

        CaptureSegment(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        public String toString() {
            return "<" + this.name + ">";
        }
    }

    static final class Match
    implements Part {
        private final String string;

        Match(String string) {
            this.string = string;
        }

        String string() {
            return this.string;
        }

        public String toString() {
            return this.string;
        }
    }

    static interface Capture
    extends Part {
        public String name();
    }

    static interface Part {
    }
}

