/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.rut;

import java.nio.CharBuffer;

final class Encoding {
    private static final int INVALID = Integer.MIN_VALUE;

    private Encoding() {
        throw new AssertionError();
    }

    static CharSequence decode(CharSequence s) {
        if (!Encoding.contains(s, '%')) {
            return s.toString();
        }
        return Encoding.decode0(s);
    }

    private static CharSequence decode0(CharSequence s) {
        int length = s.length();
        CharBuffer cb = CharBuffer.allocate(length);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c != '%') {
                cb.append(c);
                ++i;
                continue;
            }
            int b1 = Encoding.decodePercent(s, length, i);
            if (b1 == Integer.MIN_VALUE) {
                return null;
            }
            i += 3;
            int n = Encoding.utf8Length(b1);
            if (n == Integer.MIN_VALUE) {
                return null;
            }
            if (n == 1) {
                cb.append((char)b1);
                continue;
            }
            int b2 = Encoding.decodePercent(s, length, i);
            if (b2 == Integer.MIN_VALUE) {
                return null;
            }
            i += 3;
            if (n == 2) {
                int cp = Encoding.utf8Read2(b1, b2);
                if (cp == Integer.MIN_VALUE) {
                    return null;
                }
                cb.append((char)cp);
                continue;
            }
            int b3 = Encoding.decodePercent(s, length, i);
            if (b3 == Integer.MIN_VALUE) {
                return null;
            }
            i += 3;
            if (n == 3) {
                int cp = Encoding.utf8Read3(b1, b2, b3);
                if (cp == Integer.MIN_VALUE) {
                    return null;
                }
                cb.append((char)cp);
                continue;
            }
            int b4 = Encoding.decodePercent(s, length, i);
            if (b4 == Integer.MIN_VALUE) {
                return null;
            }
            i += 3;
            int cp = Encoding.utf8Read4(b1, b2, b3, b4);
            if (cp == Integer.MIN_VALUE) {
                return null;
            }
            int offset = cp - 65536;
            cb.append((char)((offset >>> 10) + 55296));
            cb.append((char)((offset & 0x3FF) + 56320));
        }
        cb.flip();
        return cb;
    }

    private static int decodePercent(CharSequence s, int length, int i) {
        if (i + 2 >= length) {
            return Integer.MIN_VALUE;
        }
        char n1 = s.charAt(i + 1);
        char n2 = s.charAt(i + 2);
        return Encoding.decodeNibbles(n1, n2);
    }

    private static int decodeNibbles(char c1, char c2) {
        int n1 = Encoding.decodeHex(c1);
        if (n1 == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        int n2 = Encoding.decodeHex(c2);
        if (n2 == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (n1 & 0xF) << 4 | n2 & 0xF;
    }

    private static int decodeHex(char c) {
        if (c < '0') {
            return Integer.MIN_VALUE;
        }
        if (c <= '9') {
            return c - 48;
        }
        if (c < 'A') {
            return Integer.MIN_VALUE;
        }
        if (c <= 'F') {
            return c - 65 + 10;
        }
        if (c < 'a') {
            return Integer.MIN_VALUE;
        }
        if (c <= 'f') {
            return c - 97 + 10;
        }
        return Integer.MIN_VALUE;
    }

    private static boolean contains(CharSequence s, char c) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private static int utf8Length(int c) {
        if (c < 128) {
            return 1;
        }
        if (c < 194) {
            return Integer.MIN_VALUE;
        }
        if (c < 224) {
            return 2;
        }
        if (c < 240) {
            return 3;
        }
        if (c < 245) {
            return 4;
        }
        return Integer.MIN_VALUE;
    }

    private static int utf8Read2(int cu1, int cu2) {
        if ((cu2 & 0xC0) != 128) {
            return Integer.MIN_VALUE;
        }
        return (cu1 << 6) + cu2 - 12416;
    }

    private static int utf8Read3(int cu1, int cu2, int cu3) {
        if ((cu2 & 0xC0) != 128) {
            return Integer.MIN_VALUE;
        }
        if (cu1 == 224 && cu2 < 160) {
            return Integer.MIN_VALUE;
        }
        if ((cu3 & 0xC0) != 128) {
            return Integer.MIN_VALUE;
        }
        return (cu1 << 12) + (cu2 << 6) + cu3 - 925824;
    }

    private static int utf8Read4(int cu1, int cu2, int cu3, int cu4) {
        if ((cu2 & 0xC0) != 128) {
            return Integer.MIN_VALUE;
        }
        if (cu1 == 240 && cu2 < 144) {
            return Integer.MIN_VALUE;
        }
        if (cu1 == 244 && cu2 >= 144) {
            return Integer.MIN_VALUE;
        }
        if ((cu3 & 0xC0) != 128) {
            return Integer.MIN_VALUE;
        }
        if ((cu4 & 0xC0) != 128) {
            return Integer.MIN_VALUE;
        }
        return (cu1 << 18) + (cu2 << 12) + (cu3 << 6) + cu4 - 63447168;
    }
}

