/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.rut;

import io.norberg.rut.Path;
import io.norberg.rut.Trie;
import java.nio.charset.Charset;
import java.util.ArrayList;

final class RadixTrie<T> {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final byte CAPTURE_SEG = -128;
    private static final byte CAPTURE_PATH = -127;
    private static final byte SLASH = 47;
    private static final byte QUERY = 63;
    private final Node<T> root;
    private final int captures;

    RadixTrie(Node<T> root) {
        this.root = root;
        this.captures = root == null ? 0 : ((Node)root).captures();
    }

    T lookup(CharSequence path) {
        return this.lookup(path, this.captor());
    }

    T lookup(CharSequence path, Captor captor) {
        captor.reset();
        return Node.fanout(this.root, path, 0, captor, 0);
    }

    int captures() {
        return this.captures;
    }

    Captor captor() {
        return RadixTrie.captor(this.captures);
    }

    static Captor captor(int captures) {
        return new Captor(captures);
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder();
    }

    private static <T> String prefixes(Node<T> node) {
        ArrayList<String> prefixes = new ArrayList<String>();
        while (node != null) {
            prefixes.add(node.prefix());
            node = node.sibling;
        }
        return ((Object)prefixes).toString();
    }

    public String toString() {
        return "RadixTrie{" + this.root + "}";
    }

    static final class Captor {
        private final int[] start;
        private final int[] end;
        private boolean match;
        private int captured;
        private int queryStart;
        private int queryEnd;
        private boolean optionalTrailingSlash;

        Captor(int captures) {
            this.start = new int[captures];
            this.end = new int[captures];
        }

        void optionalTrailingSlash(boolean optionalTrailingSlash) {
            this.optionalTrailingSlash = optionalTrailingSlash;
        }

        private void reset() {
            this.match = false;
            this.captured = 0;
            this.queryStart = -1;
            this.queryEnd = -1;
        }

        private void capture(int i, int start, int end) {
            this.start[i] = start;
            this.end[i] = end;
        }

        private void match(int captured) {
            this.match = true;
            this.captured = captured;
        }

        boolean isMatch() {
            return this.match;
        }

        int values() {
            return this.captured;
        }

        int valueStart(int i) {
            if (!this.match) {
                throw new IllegalStateException("not matched");
            }
            if (i >= this.captured) {
                throw new IndexOutOfBoundsException();
            }
            return this.start[i];
        }

        int valueEnd(int i) {
            if (!this.match) {
                throw new IllegalStateException("not matched");
            }
            if (i >= this.captured) {
                throw new IndexOutOfBoundsException();
            }
            return this.end[i];
        }

        CharSequence value(CharSequence haystack, int i) {
            if (!this.match) {
                throw new IllegalStateException("not matched");
            }
            if (i >= this.captured) {
                throw new IndexOutOfBoundsException();
            }
            return haystack.subSequence(this.start[i], this.end[i]);
        }

        private void query(int start, int end) {
            this.queryStart = start;
            this.queryEnd = end;
        }

        public int queryStart() {
            return this.queryStart;
        }

        public int queryEnd() {
            return this.queryEnd;
        }

        public CharSequence query(CharSequence haystack) {
            if (this.queryStart == -1) {
                return null;
            }
            return haystack.subSequence(this.queryStart, this.queryEnd);
        }
    }

    static final class Builder<T> {
        private final Trie<T> trie = new Trie();

        private Builder() {
        }

        Builder<T> insert(CharSequence path, T value) {
            return this.insert(Path.of(path), value);
        }

        Builder<T> insert(Path path, T value) {
            this.trie.insert(path, value);
            return this;
        }

        Builder<T> insert(Path path, Trie.Visitor<T> visitor) {
            this.trie.insert(path, visitor);
            return this;
        }

        RadixTrie<T> build() {
            return this.trie.compress();
        }

        public String toString() {
            return "Builder{trie=" + this.trie + '}';
        }
    }

    static final class Node<T> {
        private static final byte[] FULL_SEG = new byte[0];
        private final byte head;
        private final byte[] tail;
        private final Node<T> sibling;
        private final Node<T> edge;
        private final T value;

        private Node(byte head, byte[] tail, Node<T> sibling, Node<T> edge, T value) {
            this.head = head;
            this.tail = tail;
            this.sibling = sibling;
            this.edge = edge;
            this.value = value;
            if (sibling != null && head > 0 && sibling.head > 0 && head > sibling.head) {
                throw new IllegalArgumentException("unordered sibling");
            }
            if (sibling != null && head == sibling.head) {
                throw new IllegalArgumentException("duplicate sibling head");
            }
            if (head == -128 && sibling != null && sibling.head != -127) {
                throw new IllegalArgumentException("seg capture must be last or followed by path capture");
            }
            if (head == -127 && sibling != null) {
                throw new IllegalArgumentException("path capture must be last sibling");
            }
            if (value == null && edge == null) {
                throw new IllegalArgumentException("terminal node without value");
            }
        }

        private int captures() {
            int captures = this.head < 0 ? 1 : 0;
            int edgeCaptures = this.edge == null ? 0 : super.captures();
            int siblingCaptures = this.sibling == null ? 0 : super.captures();
            return captures + Math.max(edgeCaptures, siblingCaptures);
        }

        static <T> T fanout(Node<T> root, CharSequence path, int i, Captor captor, int capture) {
            T value;
            byte head;
            if (root == null) {
                return null;
            }
            if (i == path.length()) {
                return Node.terminalFanout(root, captor, capture);
            }
            char c = path.charAt(i);
            if (c == '?') {
                return Node.terminalFanout(root, captor, capture);
            }
            Node<T> node = root;
            while ((head = node.head) >= 0) {
                if (head == c) {
                    value = super.match(path, i, captor, capture);
                    if (value == null) break;
                    return value;
                }
                if (node.sibling == null) break;
                node = node.sibling;
            }
            do {
                if (node.head == -128 && (value = super.captureSeg(path, i, captor, capture)) != null) {
                    return value;
                }
                if (node.head != -127) continue;
                return super.capturePath(path, i, captor, capture);
            } while ((node = node.sibling) != null);
            return null;
        }

        private static <T> T terminalFanout(Node<T> node, Captor captor, int capture) {
            byte head;
            if (!captor.optionalTrailingSlash) {
                return null;
            }
            while ((head = node.head) >= 0) {
                if (head == 47 && node.tail == null) {
                    if (node.value != null) {
                        captor.match(capture);
                    }
                    return node.value;
                }
                node = node.sibling;
                if (node != null) continue;
            }
            return null;
        }

        private T match(CharSequence path, int index, Captor captor, int capture) {
            int next;
            int length = path.length();
            if (this.tail == null) {
                next = index + 1;
            } else {
                next = index + 1 + this.tail.length;
                if (next > length) {
                    if (captor.optionalTrailingSlash && next == length + 1 && this.value != null && this.tail[this.tail.length - 1] == 47) {
                        for (int i = 0; i < this.tail.length - 1; ++i) {
                            if (this.tail[i] == path.charAt(index + 1 + i)) continue;
                            return null;
                        }
                        captor.match(capture);
                        return this.value;
                    }
                    return null;
                }
                for (int i = 0; i < this.tail.length; ++i) {
                    if (this.tail[i] == path.charAt(index + 1 + i)) continue;
                    if (captor.optionalTrailingSlash && this.value != null && i == this.tail.length - 1 && this.tail[this.tail.length - 1] == 47 && path.charAt(index + 1 + i) == '?') {
                        captor.query(index + 2 + i, length);
                        captor.match(capture);
                        return this.value;
                    }
                    return null;
                }
            }
            if (next == length) {
                if (this.value != null) {
                    captor.match(capture);
                    return this.value;
                }
                return Node.terminalFanout(this.edge, captor, capture);
            }
            char c = path.charAt(next);
            if (c == '?') {
                if (this.value != null) {
                    captor.query(next + 1, length);
                    captor.match(capture);
                    return this.value;
                }
                T value = Node.terminalFanout(this.edge, captor, capture);
                if (value != null) {
                    captor.query(next + 1, length);
                    return value;
                }
                return null;
            }
            T value = Node.fanout(this.edge, path, next, captor, capture);
            if (value != null) {
                return value;
            }
            if (captor.optionalTrailingSlash && this.value != null && c == '/') {
                if (next + 1 == length) {
                    captor.match(capture);
                    return this.value;
                }
                if (path.charAt(next + 1) == '?') {
                    captor.match(capture);
                    captor.query(next + 2, length);
                    return this.value;
                }
            }
            return null;
        }

        private T capturePath(CharSequence path, int index, Captor captor, int capture) {
            int i;
            int length = path.length();
            for (i = index; i < length; ++i) {
                char c = path.charAt(i);
                if (c != '?') continue;
                captor.query(i + 1, length);
                break;
            }
            captor.match(capture + 1);
            captor.capture(capture, index, i);
            return this.value;
        }

        private T captureSeg(CharSequence path, int index, Captor captor, int capture) {
            int i;
            int length = path.length();
            boolean terminal = true;
            for (i = index; i < length; ++i) {
                char c = path.charAt(i);
                if (c == '/') {
                    terminal = false;
                    break;
                }
                if (c != '?') continue;
                captor.query(i + 1, length);
                break;
            }
            int limit = i;
            if (this.value != null) {
                if (terminal) {
                    captor.match(capture + 1);
                    captor.capture(capture, index, limit);
                    return this.value;
                }
                if (captor.optionalTrailingSlash) {
                    if (limit + 1 == length) {
                        captor.match(capture + 1);
                        captor.capture(capture, index, limit);
                        return this.value;
                    }
                    if (path.charAt(limit + 1) == '?') {
                        captor.match(capture + 1);
                        captor.capture(capture, index, i);
                        captor.query(limit + 2, length);
                        return this.value;
                    }
                }
            }
            if (this.edge != null) {
                T value = Node.fanout(this.edge, path, i, captor, capture + 1);
                if (value != null) {
                    captor.capture(capture, index, i);
                    return value;
                }
                if (this.tail != FULL_SEG) {
                    for (i = limit - 1; i >= index; --i) {
                        value = Node.fanout(this.edge, path, i, captor, capture + 1);
                        if (value == null) continue;
                        captor.capture(capture, index, i);
                        return value;
                    }
                }
            }
            return null;
        }

        private String prefix() {
            if (this.head == -128) {
                return "<*>";
            }
            if (this.tail == null) {
                return String.valueOf((char)this.head);
            }
            StringBuilder b = new StringBuilder().append((char)this.head);
            for (byte c : this.tail) {
                b.append((char)c);
            }
            return b.toString();
        }

        public String toString() {
            return "Node{'" + this.prefix() + "': e=" + RadixTrie.prefixes(this.edge) + ", v=" + (this.value == null ? "" : this.value.toString()) + '}';
        }

        public static <T> Node<T> terminalCaptureSeg(Node<T> sibling, T value) {
            return new Node<T>(-128, FULL_SEG, sibling, null, value);
        }

        public static <T> Node<T> captureFullSeg(Node<T> sibling, Node<T> edge, T value) {
            return new Node<T>(-128, FULL_SEG, sibling, edge, value);
        }

        static <T> Node<T> captureSeg(Node<T> sibling, Node<T> edge, T value) {
            return new Node<T>(-128, null, sibling, edge, value);
        }

        static <T> Node<T> capturePath(Node<T> sibling, T value) {
            return new Node<T>(-127, null, sibling, null, value);
        }

        static <T> Node<T> match(CharSequence prefix, Node<T> sibling, Node<T> edge, T value) {
            byte head = (byte)prefix.charAt(0);
            byte[] tail = prefix.length() == 1 ? null : prefix.subSequence(1, prefix.length()).toString().getBytes(ASCII);
            return new Node<T>(head, tail, sibling, edge, value);
        }
    }
}

