/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.rut;

import io.norberg.rut.Objects;
import io.norberg.rut.ParameterType;
import io.norberg.rut.Path;
import java.util.List;

public final class Route {
    private final String method;
    private final Path path;

    private Route(String method, Path path) {
        this.method = Objects.requireNonNull(method, "method", new Object[0]);
        this.path = Objects.requireNonNull(path, "path", new Object[0]);
    }

    public String method() {
        return this.method;
    }

    public String pathString() {
        return this.path.toString();
    }

    public List<String> captureNames() {
        return this.path.captureNames();
    }

    public List<ParameterType> captureParameterTypes() {
        return this.path.captureParameterTypes();
    }

    Path path() {
        return this.path;
    }

    public String toString() {
        return this.method + " " + this.path;
    }

    public static Route of(CharSequence method, CharSequence uri) {
        return new Route(method.toString(), Path.of(uri.toString()));
    }
}

