/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.rut;

import io.norberg.rut.Encoding;
import io.norberg.rut.ParameterType;
import io.norberg.rut.RadixTrie;
import io.norberg.rut.Route;
import io.norberg.rut.Trie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Router<T> {
    private final RadixTrie<RouteTarget<T>> trie;
    private final boolean optionalTrailingSlash;

    private Router(RadixTrie<RouteTarget<T>> trie, boolean optionalTrailingSlash) {
        this.trie = trie;
        this.optionalTrailingSlash = optionalTrailingSlash;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder();
    }

    public Status route(CharSequence method, CharSequence path, Result<T> result) {
        ((Result)result).captor.optionalTrailingSlash(this.optionalTrailingSlash);
        RouteTarget<T> route = this.trie.lookup(path, ((Result)result).captor);
        if (route == null) {
            return ((Result)result).notFound().status();
        }
        Target target = ((RouteTarget)route).lookup(method);
        if (target == null) {
            return ((Result)result).notAllowed(route).status();
        }
        return ((Result)result).success(path, route, target).status();
    }

    public Result<T> result() {
        return Result.capturing(this.trie.captures());
    }

    private static class RouteTarget<T> {
        private final String method;
        private final Target<T> target;
        private final RouteTarget<T> next;
        private final Collection<String> methods;

        private RouteTarget(String method, Target<T> target, RouteTarget<T> next) {
            this.method = method;
            this.target = target;
            this.next = next;
            this.methods = this.methods0();
        }

        private static <T> RouteTarget<T> of(String method, Target<T> target) {
            return new RouteTarget<T>(method, target, null);
        }

        private RouteTarget<T> with(String method, Target<T> target) {
            return new RouteTarget<T>(method, target, this);
        }

        private Target<T> lookup(CharSequence method) {
            RouteTarget<T> route = this;
            while (route != null) {
                if (this.equals(route.method, method)) {
                    return route.target;
                }
                route = route.next;
            }
            return null;
        }

        private boolean equals(CharSequence a, CharSequence b) {
            if (a == b) {
                return true;
            }
            int length = a.length();
            if (length != b.length()) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return false;
            }
            return true;
        }

        public Collection<String> methods() {
            return this.methods;
        }

        private Collection<String> methods0() {
            ArrayList<String> methods = new ArrayList<String>();
            RouteTarget<T> route = this;
            while (route != null) {
                methods.add(route.method);
                route = route.next;
            }
            return Collections.unmodifiableList(methods);
        }
    }

    public static class Result<T> {
        private final RadixTrie.Captor captor;
        private Status status;
        private RouteTarget<T> route;
        private Target<T> target;
        private CharSequence path;

        private Result(int captures) {
            this.captor = new RadixTrie.Captor(captures);
        }

        public static <T> Result<T> capturing(int captures) {
            return new Result<T>(captures);
        }

        public Status status() {
            return this.status;
        }

        public boolean isSuccess() {
            return this.status() == Status.SUCCESS;
        }

        public T target() {
            if (this.target == null) {
                throw new IllegalStateException("not matched");
            }
            return (T)((Target)this.target).target;
        }

        public int params() {
            return this.captor.values();
        }

        public String paramName(int i) {
            if (this.target == null) {
                throw new IllegalStateException("not matched");
            }
            return ((Target)this.target).paramNames[i];
        }

        public CharSequence paramValue(int i) {
            return this.captor.value(this.path, i);
        }

        public CharSequence paramValueDecoded(int i) {
            return Encoding.decode(this.paramValue(i));
        }

        public ParameterType paramType(int i) {
            if (this.target == null) {
                throw new IllegalStateException("not matched");
            }
            return ((Target)this.target).paramTypes[i];
        }

        public int paramValueStart(int i) {
            return this.captor.valueStart(i);
        }

        public int paramValueEnd(int i) {
            return this.captor.valueEnd(i);
        }

        private Result<T> notAllowed(RouteTarget<T> route) {
            this.status = Status.METHOD_NOT_ALLOWED;
            this.route = route;
            this.target = null;
            this.path = null;
            return this;
        }

        private Result<T> notFound() {
            this.status = Status.NOT_FOUND;
            this.route = null;
            this.target = null;
            this.path = null;
            return this;
        }

        private Result<T> success(CharSequence path, RouteTarget<T> route, Target<T> target) {
            this.status = Status.SUCCESS;
            this.route = route;
            this.target = target;
            this.path = path;
            return this;
        }

        public int queryStart() {
            return this.captor.queryStart();
        }

        public int queryEnd() {
            return this.captor.queryEnd();
        }

        public CharSequence query() {
            return this.captor.query(this.path);
        }

        public Collection<String> allowedMethods() {
            if (this.route == null) {
                throw new IllegalStateException("not matched");
            }
            return this.route.methods();
        }
    }

    public static class Builder<T> {
        private boolean optionalTrailingSlash;
        private final RadixTrie.Builder<RouteTarget<T>> trie = RadixTrie.builder();

        private Builder() {
        }

        public Router<T> build() {
            return new Router(this.trie.build(), this.optionalTrailingSlash);
        }

        public Builder<T> route(String method, String path, T target) {
            return this.route(Route.of(method, path), target);
        }

        public Builder<T> route(Route route, T target) {
            this.trie.insert(route.path(), new RouteVisitor(route, target));
            return this;
        }

        public Builder<T> optionalTrailingSlash(boolean optional) {
            this.optionalTrailingSlash = optional;
            return this;
        }

        private class RouteVisitor
        implements Trie.Visitor<RouteTarget<T>> {
            private final Route route;
            private final T target;

            public RouteVisitor(Route route, T target) {
                this.route = route;
                this.target = target;
            }

            @Override
            public RouteTarget<T> finish(RouteTarget<T> currentValue) {
                List<String> captureNames = this.route.captureNames();
                String[] paramNames = captureNames.toArray(new String[captureNames.size()]);
                List<ParameterType> parameterTypes = this.route.captureParameterTypes();
                ParameterType[] paramTypes = parameterTypes.toArray(new ParameterType[parameterTypes.size()]);
                Target target = new Target(this.target, paramNames, paramTypes);
                if (currentValue == null) {
                    return RouteTarget.of(this.route.method(), target);
                }
                return currentValue.with(this.route.method(), target);
            }
        }
    }

    private static class Target<T> {
        private final T target;
        private final String[] paramNames;
        private final ParameterType[] paramTypes;

        private Target(T target, String[] paramNames, ParameterType[] paramTypes) {
            this.target = target;
            this.paramNames = paramNames;
            this.paramTypes = paramTypes;
        }
    }

    public static enum Status {
        SUCCESS,
        NOT_FOUND,
        METHOD_NOT_ALLOWED;

    }
}

