/*
 * Decompiled with CFR 0.152.
 */
package io.norberg.rut;

import io.norberg.rut.Path;
import io.norberg.rut.RadixTrie;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

final class Trie<T> {
    private static final char CAPTURE_SEG = '\u1000';
    private static final char CAPTURE_PATH = '\u2000';
    private final Map<Character, Node<T>> roots = new TreeMap<Character, Node<T>>();

    Trie() {
    }

    T insert(Path path, T value) {
        return this.insert(path, new DefaultVisitor(value));
    }

    T insert(Path path, Visitor<T> visitor) {
        return Trie.insert(path, null, this.roots, 0, visitor);
    }

    private static <T> T insert(Path path, Node<T> node, Map<Character, Node<T>> edges, int partIndex, Visitor<T> visitor) {
        if (partIndex == path.parts().size()) {
            Object old = ((Node)node).value;
            ((Node)node).value = visitor.finish(((Node)node).value);
            return (T)old;
        }
        Path.Part part = path.parts().get(partIndex);
        if (part instanceof Path.Match) {
            return Trie.insertMatch(path, node, edges, partIndex, visitor, (Path.Match)part, 0);
        }
        if (part instanceof Path.CaptureSegment) {
            return Trie.insertCaptureSegment(path, edges, partIndex, visitor);
        }
        return Trie.insertCapturePath(edges, visitor);
    }

    private static <T> T insertCapturePath(Map<Character, Node<T>> edges, Visitor<T> visitor) {
        Node<T> capture = edges.get(Character.valueOf('\u2000'));
        if (capture == null) {
            capture = new Node('\u2000');
            edges.put(Character.valueOf('\u2000'), capture);
        }
        Object old = ((Node)capture).value;
        ((Node)capture).value = visitor.finish(((Node)capture).value);
        return (T)old;
    }

    private static <T> T insertCaptureSegment(Path path, Map<Character, Node<T>> edges, int partIndex, Visitor<T> visitor) {
        Node<T> capture = edges.get(Character.valueOf('\u1000'));
        if (capture == null) {
            capture = new Node('\u1000');
            edges.put(Character.valueOf('\u1000'), capture);
        }
        return Trie.insert(path, capture, ((Node)capture).edges, partIndex + 1, visitor);
    }

    private static <T> T insertMatch(Path path, Node<T> node, Map<Character, Node<T>> edges, int pi, Visitor<T> visitor, Path.Match part, int ci) {
        String string = part.string();
        if (ci == string.length()) {
            return Trie.insert(path, node, edges, pi + 1, visitor);
        }
        char c = string.charAt(ci);
        Node<T> next = edges.get(Character.valueOf(c));
        if (next == null) {
            next = new Node(c);
            edges.put(Character.valueOf(c), next);
        }
        return Trie.insertMatch(path, next, ((Node)next).edges, pi, visitor, part, ci + 1);
    }

    RadixTrie<T> compress() {
        return new RadixTrie<T>(Trie.compressEdges(this.roots));
    }

    private static <T> RadixTrie.Node<T> compressEdges(Map<Character, Node<T>> nodes) {
        RadixTrie.Node node = null;
        for (Node<T> e : Trie.reversed(nodes.values())) {
            node = ((Node)e).compress(node);
        }
        return node;
    }

    public String toString() {
        return "Trie{roots=" + this.roots + '}';
    }

    private static <T> Collection<T> reversed(Collection<T> values) {
        ArrayList<T> list = new ArrayList<T>(values);
        Collections.reverse(list);
        return list;
    }

    private class DefaultVisitor
    implements Visitor<T> {
        private final T value;

        public DefaultVisitor(T value) {
            this.value = value;
        }

        @Override
        public T finish(T currentValue) {
            return this.value;
        }
    }

    static interface Visitor<T> {
        public T finish(T var1);
    }

    private static final class Node<T> {
        private static final char SLASH = '/';
        private final char c;
        private final Map<Character, Node<T>> edges = new TreeMap<Character, Node<T>>();
        private T value;

        private Node(char c) {
            this(c, null);
        }

        private Node(char c, T value) {
            this.c = c;
            this.value = value;
        }

        private RadixTrie.Node<T> compress(RadixTrie.Node<T> sibling) {
            if (this.c == '\u1000') {
                if (this.edges.size() == 0) {
                    return RadixTrie.Node.terminalCaptureSeg(sibling, this.value);
                }
                if (this.edges.size() == 1) {
                    Node<T> edge = this.edges.values().iterator().next();
                    if (edge.c == '/') {
                        return RadixTrie.Node.captureFullSeg(sibling, Trie.compressEdges(this.edges), this.value);
                    }
                }
                return RadixTrie.Node.captureSeg(sibling, Trie.compressEdges(this.edges), this.value);
            }
            if (this.c == '\u2000') {
                return RadixTrie.Node.capturePath(sibling, this.value);
            }
            StringBuilder prefix = new StringBuilder();
            Node<T> end = this.compress(prefix);
            RadixTrie.Node edge = Trie.compressEdges(end.edges);
            return RadixTrie.Node.match(prefix, sibling, edge, end.value);
        }

        private Node<T> compress(StringBuilder prefix) {
            Node<T> node = this;
            while (true) {
                prefix.append(node.c);
                if (node.value != null || node.edges.size() != 1) {
                    return node;
                }
                Node<T> next = node.edges.values().iterator().next();
                if (next.c == '\u1000' || next.c == '\u2000') {
                    return node;
                }
                node = next;
            }
        }

        public String toString() {
            return "Node{'" + this.name() + "'" + ", edges=" + this.edges.size() + ", value=" + this.value + '}';
        }

        private String name() {
            switch (this.c) {
                case '\u1000': {
                    return "<*>";
                }
                case '\u2000': {
                    return "<*:path>";
                }
            }
            return String.valueOf(this.c);
        }
    }
}

