/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityconfig.yaml;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.nosqlbench.engine.api.util.Tagged;
import io.nosqlbench.nb.api.config.params.Element;
import io.nosqlbench.nb.api.config.params.NBParams;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public abstract class OpTemplate
implements Tagged {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static final String FIELD_DESC = "description";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_OP = "op";
    public static final String FIELD_BINDINGS = "bindings";
    public static final String FIELD_PARAMS = "params";
    public static final String FIELD_TAGS = "tags";

    public abstract String getDesc();

    public abstract String getName();

    public abstract Map<String, String> getTags();

    public abstract Map<String, String> getBindings();

    public abstract Map<String, Object> getParams();

    public <T> Map<String, T> getParamsAsValueType(Class<? extends T> type) {
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>();
        for (String pname : this.getParams().keySet()) {
            Object object = this.getParams().get(pname);
            if (object == null) continue;
            if (type.isAssignableFrom(object.getClass())) {
                map.put(pname, type.cast(object));
                continue;
            }
            throw new RuntimeException("With param named '" + pname + "' You can't assign an object of type '" + object.getClass().getSimpleName() + "' to '" + type.getSimpleName() + "'. Maybe the YAML format is suggesting the wrong type.");
        }
        return map;
    }

    public <V> V removeParamOrDefault(String name, V defaultValue) {
        Objects.requireNonNull(defaultValue);
        if (!this.getParams().containsKey(name)) {
            return defaultValue;
        }
        Object value = this.getParams().remove(name);
        try {
            return (V)defaultValue.getClass().cast(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to cast type " + value.getClass().getCanonicalName() + " to " + defaultValue.getClass().getCanonicalName(), e);
        }
    }

    public <V> V getParamOrDefault(String name, V defaultValue) {
        Objects.requireNonNull(defaultValue);
        if (!this.getParams().containsKey(name)) {
            return defaultValue;
        }
        Object value = this.getParams().get(name);
        try {
            return (V)defaultValue.getClass().cast(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to cast type " + value.getClass().getCanonicalName() + " to " + defaultValue.getClass().getCanonicalName(), e);
        }
    }

    public <V> V getParam(String name, Class<? extends V> type) {
        Object object = this.getParams().get(name);
        if (object == null) {
            return null;
        }
        if (type.isAssignableFrom(object.getClass())) {
            V value = type.cast(object);
            return value;
        }
        throw new RuntimeException("Unable to cast type " + object.getClass().getSimpleName() + " to " + type.getSimpleName() + ". Perhaps the yaml format is suggesting the wrong type.");
    }

    public <V> Optional<V> getOptionalStringParam(String name, Class<? extends V> type) {
        if (type.isPrimitive()) {
            throw new RuntimeException("Do not use primitive types for the target class here. For example, Boolean.class is accepted, but boolean.class is not.");
        }
        if (this.getParams().containsKey(name)) {
            Object object = this.getParams().get(name);
            if (object == null) {
                return Optional.empty();
            }
            try {
                V reified = type.cast(object);
                return Optional.of(reified);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to cast type " + object.getClass().getCanonicalName() + " to " + type.getCanonicalName());
            }
        }
        return Optional.empty();
    }

    public Optional<String> getOptionalStringParam(String name) {
        return this.getOptionalStringParam(name, String.class);
    }

    public Optional<ParsedTemplate> getParsed(Function<String, String> ... rewriters) {
        Optional<String> os = this.getStmt();
        return os.map(s -> {
            String result = s;
            for (Function rewriter : rewriters) {
                result = (String)rewriter.apply(result);
            }
            return result;
        }).map(s -> new ParsedTemplate(s, this.getBindings()));
    }

    public Optional<ParsedTemplate> getParsed() {
        return this.getStmt().map(s -> new ParsedTemplate(s, this.getBindings()));
    }

    public abstract Optional<Map<String, Object>> getOp();

    public Map<String, Object> asData() {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        if (this.getDesc() != null && !this.getDesc().isBlank()) {
            fields.put(FIELD_DESC, this.getDesc());
        }
        if (this.getBindings().size() > 0) {
            fields.put(FIELD_BINDINGS, this.getBindings());
        }
        if (this.getParams().size() > 0) {
            fields.put(FIELD_PARAMS, this.getParams());
        }
        if (this.getTags().size() > 0) {
            fields.put(FIELD_TAGS, this.getTags());
        }
        this.getOp().ifPresent(o -> fields.put(FIELD_OP, o));
        fields.put(FIELD_NAME, this.getName());
        return fields;
    }

    public Optional<String> getStmt() {
        return this.getOp().map(m -> m.get("stmt")).map(s -> {
            if (s instanceof CharSequence) {
                return s.toString();
            }
            return gson.toJson(s);
        });
    }

    public Element getParamReader() {
        return NBParams.one((String)this.getName(), this.getParams());
    }
}

