/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.activityimpl.uniform.fieldmappers;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class FieldDestructuringMapper
implements Function<Map<String, Object>, Map<String, Object>> {
    private final String fieldname;
    private final Function<String, Optional<Map<String, Object>>> thenfunc;

    public FieldDestructuringMapper(String fieldName, Function<String, Optional<Map<String, Object>>> thenfunc) {
        this.fieldname = fieldName;
        this.thenfunc = thenfunc;
    }

    @Override
    public Map<String, Object> apply(Map<String, Object> stringObjectMap) {
        if (stringObjectMap.containsKey(this.fieldname)) {
            Object o = stringObjectMap.get(this.fieldname);
            if (o instanceof CharSequence) {
                String rawfield = o.toString();
                Optional<Map<String, Object>> optionalResult = this.thenfunc.apply(rawfield);
                if (optionalResult.isPresent()) {
                    Map<String, Object> resultmap = optionalResult.get();
                    LinkedHashMap<String, Object> returnmap = new LinkedHashMap<String, Object>(stringObjectMap);
                    returnmap.remove(this.fieldname);
                    resultmap.forEach((k, v) -> {
                        if (returnmap.containsKey(k)) {
                            throw new RuntimeException("element '" + k + "' already exist during field remapping.");
                        }
                        returnmap.put((String)k, v);
                    });
                    return returnmap;
                }
                return stringObjectMap;
            }
            throw new RuntimeException("During op mapping, can't parse something that is not a CharSequence: '" + this.fieldname + "' (type is " + o.getClass().getCanonicalName() + ")");
        }
        return stringObjectMap;
    }
}

