/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.metrics;

import com.codahale.metrics.Timer;
import io.nosqlbench.engine.api.activityimpl.ActivityDef;
import io.nosqlbench.engine.api.metrics.ActivityMetrics;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadLocalNamedTimers {
    private static final Logger logger = LogManager.getLogger(ThreadLocalNamedTimers.class);
    public static final ThreadLocal<ThreadLocalNamedTimers> TL_INSTANCE = ThreadLocal.withInitial(ThreadLocalNamedTimers::new);
    private static final Map<String, Timer> timers = new HashMap<String, Timer>();
    private final Map<String, Timer.Context> contexts = new HashMap<String, Timer.Context>();

    public static void addTimer(ActivityDef def, String name) {
        if (timers.containsKey("name")) {
            logger.warn("A timer named '" + name + "' was already defined and initialized.");
        }
        Timer timer = ActivityMetrics.timer((ActivityDef)def, (String)name);
        timers.put(name, timer);
    }

    public void start(String name) {
        Timer.Context context = timers.get(name).time();
        this.contexts.put(name, context);
    }

    public void stop(String name) {
        Timer.Context context = this.contexts.get(name);
        context.stop();
    }

    public void start(List<String> timerName) {
        for (String startTimer : timerName) {
            this.start(startTimer);
        }
    }

    public void stop(List<String> timerName) {
        for (String stopTimer : timerName) {
            this.stop(stopTimer);
        }
    }
}

