/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.templating;

import io.nosqlbench.engine.api.activityconfig.yaml.OpTemplate;
import io.nosqlbench.engine.api.templating.ObjectCache;
import io.nosqlbench.engine.api.templating.binders.ArrayBinder;
import io.nosqlbench.engine.api.templating.binders.ListBinder;
import io.nosqlbench.engine.api.templating.binders.OrderedMapBinder;
import io.nosqlbench.nb.api.config.fieldreaders.DynamicFieldReader;
import io.nosqlbench.nb.api.config.fieldreaders.StaticFieldReader;
import io.nosqlbench.nb.api.config.standard.NBConfigError;
import io.nosqlbench.nb.api.config.standard.NBConfiguration;
import io.nosqlbench.nb.api.config.standard.NBTypeConverter;
import io.nosqlbench.nb.api.errors.BasicError;
import io.nosqlbench.nb.api.errors.OpConfigError;
import io.nosqlbench.virtdata.core.bindings.VirtData;
import io.nosqlbench.virtdata.core.templates.BindPoint;
import io.nosqlbench.virtdata.core.templates.CapturePoint;
import io.nosqlbench.virtdata.core.templates.ParsedTemplate;
import io.nosqlbench.virtdata.core.templates.StringBindings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParsedOp
implements LongFunction<Map<String, ?>>,
StaticFieldReader,
DynamicFieldReader {
    private static final Logger logger = LogManager.getLogger(ParsedOp.class);
    private final Map<String, Object> statics = new LinkedHashMap<String, Object>();
    private final Map<String, LongFunction<?>> dynamics = new LinkedHashMap();
    private final List<List<CapturePoint>> captures = new ArrayList<List<CapturePoint>>();
    private final int mapsize;
    private final LinkedHashMap<String, Object> protomap = new LinkedHashMap();
    private final OpTemplate ot;
    private final NBConfiguration activityCfg;

    public ParsedOp(OpTemplate ot, NBConfiguration activityCfg) {
        this(ot, activityCfg, List.of());
    }

    public ParsedOp(OpTemplate opTemplate, NBConfiguration activityCfg, List<Function<Map<String, Object>, Map<String, Object>>> preprocessors) {
        this.ot = opTemplate;
        this.activityCfg = activityCfg;
        Map<String, Object> map = opTemplate.getOp().orElseThrow();
        for (Function<Map<String, Object>, Map<String, Object>> preprocessor : preprocessors) {
            map = preprocessor.apply(map);
        }
        this.applyTemplateFields(map, opTemplate.getBindings());
        this.mapsize = this.statics.size() + this.dynamics.size();
    }

    private void applyTemplateFields(Map<String, Object> map, Map<String, String> bindings) {
        map.forEach((k, v) -> {
            if (v instanceof CharSequence) {
                ParsedTemplate pt = ParsedTemplate.of((String)((CharSequence)v).toString(), (Map)bindings);
                this.captures.add(pt.getCaptures());
                switch (pt.getType()) {
                    case literal: {
                        this.statics.put((String)k, ((CharSequence)v).toString());
                        this.protomap.put((String)k, ((CharSequence)v).toString());
                        break;
                    }
                    case bindref: {
                        String spec = ((BindPoint)pt.asBinding().orElseThrow()).getBindspec();
                        Optional mapper = VirtData.getOptionalMapper((String)spec);
                        this.dynamics.put((String)k, (LongFunction)mapper.orElseThrow());
                        this.protomap.put((String)k, null);
                        break;
                    }
                    case concat: {
                        StringBindings sb = new StringBindings(pt);
                        this.dynamics.put((String)k, (LongFunction<?>)sb);
                        this.protomap.put((String)k, null);
                    }
                }
            } else {
                this.statics.put((String)k, v);
                this.protomap.put((String)k, v);
            }
        });
    }

    public String getName() {
        return this.ot.getName();
    }

    public Map<String, Object> getStaticPrototype() {
        return this.statics;
    }

    public Map<String, LongFunction<?>> getDynamicPrototype() {
        return this.dynamics;
    }

    @Override
    public Map<String, Object> apply(long value) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.protomap);
        this.dynamics.forEach((k, v) -> map.put((String)k, v.apply(value)));
        return map;
    }

    public boolean isDefinedDynamic(String field) {
        return this.dynamics.containsKey(field);
    }

    public boolean isStatic(String field) {
        return this.statics.containsKey(field);
    }

    public boolean isStatic(String field, Class<?> type) {
        return this.statics.containsKey(field) && type.isAssignableFrom(field.getClass());
    }

    public boolean isDefined(String ... fields) {
        for (String field : fields) {
            if (this.statics.containsKey(field)) continue;
            return false;
        }
        return true;
    }

    public <T> T getStaticValue(String field, Class<T> classOfT) {
        return (T)this.statics.get(field);
    }

    public <T> T getStaticValue(String field) {
        return (T)this.statics.get(field);
    }

    public Optional<ParsedTemplate> getStmtAsTemplate() {
        return this.ot.getParsed();
    }

    public <T> T getStaticValueOr(String name, T defaultValue) {
        if (this.statics.containsKey(name)) {
            return (T)this.statics.get(name);
        }
        if (this.dynamics.containsKey(name)) {
            throw new BasicError("static field '" + name + "' was defined dynamically. This may be supportable if the driver developerupdates the op mapper to support this field as a dynamic field, but it is not yet supported.");
        }
        return defaultValue;
    }

    public <T> T getStaticConfigOr(String name, T defaultValue) {
        if (this.statics.containsKey(name)) {
            return (T)NBTypeConverter.convertOr((Object)this.statics.get(name), defaultValue);
        }
        if (this.ot.getParams().containsKey(name)) {
            return (T)NBTypeConverter.convertOr((Object)this.ot.getParams().get(name), defaultValue);
        }
        if (this.activityCfg.getMap().containsKey(name)) {
            return (T)NBTypeConverter.convertOr((Object)this.activityCfg.get("name"), defaultValue);
        }
        if (this.dynamics.containsKey(name)) {
            throw new NBConfigError("static config field '" + name + "' was defined dynamically. This may be supportable if the driver developerupdates the op mapper to support this field as a dynamic field, but it is not yet supported.");
        }
        return defaultValue;
    }

    public <T> Optional<T> getOptionalStaticConfig(String name, Class<T> type) {
        if (this.statics.containsKey(name)) {
            return Optional.of(NBTypeConverter.convert((Object)this.statics.get(name), type));
        }
        if (this.ot.getParams().containsKey(name)) {
            return Optional.of(NBTypeConverter.convert((Object)this.ot.getParams().get(name), type));
        }
        if (this.activityCfg.getMap().containsKey(name)) {
            return Optional.of(NBTypeConverter.convert((Object)this.activityCfg.get("name"), type));
        }
        if (this.dynamics.containsKey("name")) {
            throw new NBConfigError("static config field '" + name + "' was defined dynamically. This may be supportable if the driver developerupdates the op mapper to support this field as a dynamic field, but it is not yet supported.");
        }
        return Optional.empty();
    }

    public <T> T getConfigOr(String name, T defaultValue, long input) {
        if (this.statics.containsKey(name)) {
            return (T)NBTypeConverter.convertOr((Object)this.statics.get(name), defaultValue);
        }
        if (this.dynamics.containsKey(name)) {
            return (T)NBTypeConverter.convertOr(this.dynamics.get(name).apply(input), defaultValue);
        }
        if (this.ot.getParams().containsKey(name)) {
            return (T)NBTypeConverter.convertOr((Object)this.ot.getParams().get(name), defaultValue);
        }
        if (this.activityCfg.getMap().containsKey(name)) {
            return (T)NBTypeConverter.convertOr((Object)this.activityCfg.get("name"), defaultValue);
        }
        return defaultValue;
    }

    public <T> Optional<T> getOptionalValue(String field, Class<T> classOfT) {
        return Optional.ofNullable(this.getStaticValue(field, classOfT));
    }

    public <T> Optional<T> getStaticValueOptionally(String field) {
        return Optional.ofNullable(this.getStaticValue(field));
    }

    public <T> T get(String field, long input) {
        if (this.statics.containsKey(field)) {
            return (T)this.statics.get(field);
        }
        if (this.dynamics.containsKey(field)) {
            return (T)this.dynamics.get(field).apply(input);
        }
        return null;
    }

    public Set<String> getDefinedNames() {
        HashSet<String> nameSet = new HashSet<String>(this.statics.keySet());
        nameSet.addAll(this.dynamics.keySet());
        return nameSet;
    }

    public <V> LongFunction<V> getAsFunction(String name, Class<? extends V> type) {
        if (this.isStatic(name)) {
            Object value = this.getStaticValue(name);
            return cycle -> value;
        }
        if (this.isDefinedDynamic(name)) {
            Object testValue = this.dynamics.get(name).apply(0L);
            if (type.isAssignableFrom(testValue.getClass())) {
                return this.dynamics.get(name);
            }
            throw new OpConfigError("function for '" + name + "' yielded a " + testValue.getClass().getCanonicalName() + " type, which is not assignable to " + type.getClass().getCanonicalName() + "'");
        }
        throw new OpConfigError("No op field named '" + name + "' was found. If this field has a reasonable default value, consider using getAsFunctionOr(...) and documenting the default.");
    }

    public <V> LongFunction<V> getAsFunctionOr(String name, V defaultValue) {
        if (this.isStatic(name)) {
            Object value = this.getStaticValue(name);
            return l -> value;
        }
        if (this.isDefinedDynamic(name)) {
            return l -> this.get(name, l);
        }
        return l -> defaultValue;
    }

    public <V> LongFunction<V> getAsCachedFunctionOr(String fieldname, String defaultValue, Function<String, V> init) {
        if (this.isStatic(fieldname)) {
            Object value = this.getStaticValue(fieldname);
            if (value instanceof String) {
                Object defaultObject = init.apply((String)value);
                return l -> defaultObject;
            }
            throw new OpConfigError("Unable to compose string to object cache with non-String value of type " + defaultValue.getClass().getCanonicalName());
        }
        if (this.isDefinedDynamic(fieldname)) {
            LongFunction<Object> f = l -> this.get(fieldname, l);
            Object testValue = f.apply(0L);
            if (testValue instanceof String) {
                LongFunction<String> fs = l -> (String)this.get(fieldname, l);
                ObjectCache oc = new ObjectCache(init);
                return l -> oc.apply((String)fs.apply(l));
            }
            throw new OpConfigError("Unable to compose string func to obj cache with non-String function of type " + f.getClass().getCanonicalName());
        }
        throw new OpConfigError("Unable to compose string func to obj cache with no defined static nor dynamic field named " + fieldname);
    }

    public boolean isDefined(String field) {
        return this.statics.containsKey(field) || this.dynamics.containsKey(field);
    }

    public boolean isDefined(String field, Class<?> type) {
        if (this.statics.containsKey(field)) {
            if (type.isAssignableFrom(this.statics.get(field).getClass())) {
                return true;
            }
            throw new OpConfigError("field " + field + " was defined, but not as the requested type " + type.getCanonicalName());
        }
        if (this.dynamics.containsKey(field)) {
            Object testObject = this.dynamics.get(field).apply(0L);
            if (type.isAssignableFrom(testObject.getClass())) {
                return true;
            }
            throw new OpConfigError("field " + field + " was defined as a function, but not one that returns the requested type " + testObject.getClass().getCanonicalName());
        }
        return false;
    }

    public boolean isDefinedAll(String ... fields) {
        for (String field : fields) {
            if (this.statics.containsKey(field) || this.dynamics.containsKey(field)) continue;
            return false;
        }
        return true;
    }

    public void assertDefinedStatic(String ... fields) {
        for (String field : fields) {
            if (this.statics.containsKey(field)) continue;
            HashSet<String> missing = new HashSet<String>();
            for (String readoutfield : fields) {
                if (this.statics.containsKey(readoutfield)) continue;
                missing.add(readoutfield);
            }
            throw new OpConfigError("Fields " + missing + " are required to be defined with static values for this type of operation.");
        }
    }

    public LongFunction<List<Object>> newListBinder(String ... fields) {
        return new ListBinder(this, fields);
    }

    public LongFunction<List<Object>> newListBinder(List<String> fields) {
        return new ListBinder(this, fields);
    }

    public LongFunction<Map<String, Object>> newOrderedMapBinder(String ... fields) {
        return new OrderedMapBinder(this, fields);
    }

    public LongFunction<Object[]> newArrayBinder(String ... fields) {
        return new ArrayBinder(this, fields);
    }

    public LongFunction<Object[]> newArrayBinder(List<String> fields) {
        return new ArrayBinder(this, fields);
    }

    public LongFunction<Object[]> newArrayBinderFromBindPoints(List<BindPoint> bindPoints) {
        return new ArrayBinder(bindPoints);
    }

    public LongFunction<?> getMapper(String field) {
        LongFunction<?> mapper = this.dynamics.get(field);
        return mapper;
    }

    public int getSize() {
        return this.mapsize;
    }

    public boolean isUndefined(String field) {
        return !this.statics.containsKey(field) && !this.dynamics.containsKey(field);
    }
}

