/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.engine.api.templating.binders;

import io.nosqlbench.engine.api.templating.ParsedOp;
import io.nosqlbench.nb.api.errors.OpConfigError;
import io.nosqlbench.virtdata.core.bindings.VirtData;
import io.nosqlbench.virtdata.core.templates.BindPoint;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.LongFunction;

public class ArrayBinder
implements LongFunction<Object[]> {
    private final Object[] protoary;
    private final LongFunction<?>[] mapperary;
    private final int[] dindexes;

    public ArrayBinder(ParsedOp cmd, String[] fields) {
        this.protoary = new Object[fields.length];
        this.mapperary = new LongFunction[fields.length];
        int[] indexes = new int[fields.length];
        int nextIndex = 0;
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (cmd.isStatic(field)) {
                this.protoary[i] = cmd.getStaticValue(field);
                continue;
            }
            if (cmd.isDefinedDynamic(field)) {
                this.mapperary[i] = cmd.getMapper(field);
                indexes[nextIndex++] = i;
                continue;
            }
            throw new OpConfigError("There was no field named '" + field + "' while building an ArrayBinder.");
        }
        this.dindexes = Arrays.copyOf(indexes, nextIndex);
    }

    public ArrayBinder(ParsedOp cmd, List<String> fields) {
        this(cmd, fields.toArray(new String[0]));
    }

    public ArrayBinder(List<BindPoint> bindPoints) {
        this.protoary = new Object[bindPoints.size()];
        this.mapperary = new LongFunction[bindPoints.size()];
        int[] indexes = new int[bindPoints.size()];
        int nextIndex = 0;
        int i = 0;
        while (i < bindPoints.size()) {
            BindPoint bindPoint = bindPoints.get(i);
            Optional mapper = VirtData.getOptionalMapper((String)bindPoint.getBindspec());
            this.mapperary[i] = (LongFunction)mapper.orElseThrow();
            indexes[nextIndex++] = i++;
        }
        this.dindexes = Arrays.copyOf(indexes, nextIndex);
    }

    @Override
    public Object[] apply(long value) {
        Object[] ary = Arrays.copyOf(this.protoary, this.protoary.length);
        for (int dindex : this.dindexes) {
            ary[dindex] = this.mapperary[dindex].apply(value);
        }
        return ary;
    }
}

