/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.docsys.core;

import io.nosqlbench.docsys.DocsysDefaultAppPath;
import io.nosqlbench.docsys.api.Docs;
import io.nosqlbench.docsys.api.WebServiceObject;
import io.nosqlbench.docsys.core.DocsysPathLoader;
import io.nosqlbench.docsys.handlers.FavIconHandler;
import io.nosqlbench.nb.api.spi.SimpleServiceLoader;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRegistration;
import java.awt.Desktop;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.AccessMode;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.rewrite.handler.RewriteHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;
import org.glassfish.jersey.servlet.ServletContainer;

public class NBWebServer
implements Runnable {
    private static final Logger logger = LogManager.getLogger(NBWebServer.class);
    private final List<Path> basePaths = new ArrayList<Path>();
    private final List<Class> servletClasses = new ArrayList<Class>();
    private ServletContextHandler contextHandler;
    private ServletHolder servletHolder;
    private HandlerList handlers;
    private String bindScheme = "http";
    private String bindHost = "localhost";
    private int bindPort = 12345;
    private final Map<String, Object> contextParams = new LinkedHashMap<String, Object>();

    public NBWebServer withContextParams(Map<String, Object> cp) {
        this.contextParams.putAll(cp);
        return this;
    }

    public NBWebServer withContextParam(String name, Object object) {
        this.contextParams.put(name, object);
        return this;
    }

    public NBWebServer withHost(String bindHost) {
        this.bindHost = bindHost;
        return this;
    }

    public NBWebServer withPort(int bindPort) {
        this.bindPort = bindPort;
        return this;
    }

    public NBWebServer withURL(String urlSpec) {
        try {
            URL url = new URL(urlSpec);
            this.bindPort = url.getPort();
            this.bindHost = url.getHost();
            this.bindScheme = url.getProtocol();
            if (url.getPath() != null && !url.getPath().equals("/") && !url.getPath().equals("")) {
                throw new UnsupportedOperationException("You may not specify a path for the hosting URL. (specified '" + url.getPath() + "')");
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public NBWebServer withScheme(String scheme) {
        this.bindScheme = scheme;
        return this;
    }

    private void addWebObject(Class<?> ... objects) {
        this.servletClasses.addAll(Arrays.asList(objects));
    }

    private void loadDynamicEndpoints() {
        List<Pattern> includeApps = List.of(Pattern.compile(".*"));
        if (this.contextParams.containsKey("include-apps")) {
            includeApps = Arrays.asList(this.contextParams.get("include-apps").toString().split(", *")).stream().map(Pattern::compile).collect(Collectors.toList());
        }
        SimpleServiceLoader svcLoader = new SimpleServiceLoader(WebServiceObject.class);
        svcLoader.getNamedProviders(new Pattern[0]).values().forEach(p -> {
            Class c = p.type();
            logger.info("Adding web service object: " + c.getSimpleName());
            this.addWebObject(c);
        });
        logger.debug("Loaded " + this.servletClasses.size() + " root resources.");
    }

    private ServletContextHandler getContextHandler() {
        if (this.contextHandler == null) {
            this.contextHandler = new ServletContextHandler();
            this.contextHandler.setContextPath("/*");
        }
        return this.contextHandler;
    }

    private ServletHolder getServletHolder() {
        if (this.servletHolder == null) {
            this.servletHolder = this.getContextHandler().addServlet(ServletContainer.class, "/apps");
            this.servletHolder.setInitOrder(0);
        }
        return this.servletHolder;
    }

    public NBWebServer addPaths(Path ... paths) {
        for (Path path : paths) {
            try {
                path.getFileSystem().provider().checkAccess(path, AccessMode.READ);
                this.basePaths.add(path);
            }
            catch (Exception e) {
                logger.error("Unable to access path " + path.toString());
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    @Override
    public void run() {
        Server server = new Server(this.bindPort);
        this.handlers = new HandlerList();
        if (this.basePaths.size() == 0 && this.servletClasses.size() == 0) {
            logger.warn("No service endpoints or doc paths have been added. Loading dynamically.");
        }
        RewriteHandler rh = new RewriteHandler();
        this.handlers.addHandler((Handler)rh);
        for (Path basePath : this.basePaths) {
            Path icon = basePath.resolve("/favicon.ico");
            if (!Files.exists(icon, new LinkOption[0])) continue;
            FavIconHandler favIconHandler = new FavIconHandler(this.basePaths.get(0) + "/favicon.ico", false);
            this.handlers.addHandler((Handler)favIconHandler);
            break;
        }
        if (this.basePaths.size() == 0) {
            Docs docs = new Docs();
            docs.merge(DocsysPathLoader.loadStaticPaths());
            if (!docs.getPathMap().containsKey("docsys-app")) {
                docs.merge(new DocsysDefaultAppPath().getDocs());
            }
            this.basePaths.addAll(docs.getPaths());
        }
        for (Path basePath : this.basePaths) {
            logger.info("Adding path to server: " + basePath.toString());
            ResourceHandler resourceHandler = new ResourceHandler();
            resourceHandler.setDirAllowed(true);
            resourceHandler.setAcceptRanges(true);
            resourceHandler.setWelcomeFiles(new String[]{"index.html"});
            resourceHandler.setRedirectWelcome(false);
            PathResource baseResource = new PathResource(basePath);
            if (basePath.toUri().toString().startsWith("jar:")) {
                try {
                    baseResource = JarResource.newResource((URI)basePath.toUri());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            resourceHandler.setBaseResource((org.eclipse.jetty.util.resource.Resource)baseResource);
            resourceHandler.setCacheControl("no-cache");
            this.handlers.addHandler((Handler)resourceHandler);
        }
        logger.info("adding " + this.servletClasses.size() + " context handlers...");
        this.loadDynamicEndpoints();
        ResourceConfig rc = new ResourceConfig();
        rc.addProperties(this.contextParams);
        rc.property("server", (Object)this);
        ServletContainer container = new ServletContainer(rc);
        ServletHolder servlets = new ServletHolder((Servlet)container);
        String classnames = this.servletClasses.stream().map(Class::getCanonicalName).collect(Collectors.joining(","));
        rc.property("jersey.config.server.provider.classnames", (Object)classnames);
        ServletContextHandler sch = new ServletContextHandler();
        sch.setContextPath("/*");
        sch.addServlet(servlets, "/*");
        FilterHolder filter = new FilterHolder();
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,HEAD");
        filter.setInitParameter("allowedHeaders", "X-PINGOTHER, Origin, X-Requested-With, Content-Type, Accept");
        filter.setInitParameter("preflightMaxAge", "1800");
        filter.setInitParameter("allowCredentials", "true");
        CrossOriginFilter corsFilter = new CrossOriginFilter();
        filter.setFilter((Filter)corsFilter);
        FilterMapping filterMapping = new FilterMapping();
        filterMapping.setDispatcherTypes(EnumSet.of(DispatcherType.REQUEST));
        filterMapping.setPathSpec("/*");
        filterMapping.setServletName("cross-origin");
        sch.addFilter(filter, "/*", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        this.handlers.addHandler((Handler)sch);
        DefaultHandler defaultHandler = new DefaultHandler();
        defaultHandler.setShowContexts(true);
        defaultHandler.setServeIcon(false);
        this.handlers.addHandler((Handler)defaultHandler);
        server.setHandler((Handler)this.handlers);
        for (Connector connector : server.getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            logger.debug("Setting idle timeout for " + connector.toString() + " to 300,000ms");
            ((AbstractConnector)connector).setIdleTimeout(300000L);
        }
        try {
            ArrayList<ServerConnector> connectors = new ArrayList<ServerConnector>();
            if (this.bindScheme.equals("http")) {
                ServerConnector sc = new ServerConnector(server);
                sc.setPort(this.bindPort);
                sc.setHost(this.bindHost);
                connectors.add(sc);
            } else if (this.bindScheme.equals("https")) {
                SslContextFactory.Server server1 = new SslContextFactory.Server();
                ServerConnector sc = new ServerConnector(server, server1);
                sc.setPort(this.bindPort);
                sc.setHost(this.bindHost);
                connectors.add(sc);
            }
            server.setConnectors(connectors.toArray(new Connector[0]));
            server.start();
            System.out.println("Started documentation server at " + this.bindScheme + "://" + this.bindHost + ":" + this.bindPort + "/");
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                System.out.println("Browsing to documentation server at " + this.bindScheme + "://" + this.bindHost + ":" + this.bindPort + "/");
                Desktop.getDesktop().browse(new URI(this.bindScheme + "://" + this.bindHost + ":" + this.bindPort + "/"));
                System.out.println("If the docs app did not open automatically in your browser, open to the the url above.");
            }
            server.join();
        }
        catch (Exception e) {
            logger.error("error while starting doc server", (Throwable)e);
            e.printStackTrace(System.out);
            System.exit(2);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Class servletClass : this.servletClasses) {
            sb.append("- ").append(servletClass.getCanonicalName()).append("\n");
            ResourceConfig rc = new ResourceConfig(new Class[]{servletClass});
            Set resources = rc.getResources();
            for (Resource resource : resources) {
                sb.append("resource name:").append(resource.getName()).append("\n");
                List resourceMethods = resource.getResourceMethods();
                for (ResourceMethod resourceMethod : resourceMethods) {
                    String rm = resourceMethod.toString();
                    sb.append("rm:").append(rm);
                }
            }
        }
        sb.append("- - - -\n");
        for (Handler handler : this.handlers.getHandlers()) {
            String summary = this.handlerSummary(handler);
            sb.append(summary == null ? "NULL SUMMARY" : summary);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String handlerSummary(Handler handler) {
        StringBuilder sb = new StringBuilder();
        sb.append("----> handler type ").append(handler.getClass().getSimpleName()).append("\n");
        if (handler instanceof ResourceHandler) {
            ResourceHandler h = (ResourceHandler)handler;
            sb.append(" base resource: ").append(h.getBaseResource().toString()).append("\n");
            sb.append(h.dump());
        } else if (handler instanceof ServletContextHandler) {
            ServletContextHandler h = (ServletContextHandler)handler;
            sb.append(h.dump()).append("\n");
            h.getServletContext().getServletRegistrations().forEach((k, v) -> {
                sb.append("==> servlet type ").append((String)k).append("\n");
                sb.append(this.getServletSummary((ServletRegistration)v)).append("\n");
            });
            sb.append("context path:").append(h.getContextPath());
        } else if (handler instanceof DefaultHandler) {
            DefaultHandler h = (DefaultHandler)handler;
            sb.append(h.dump());
        }
        return sb.toString();
    }

    private String getServletSummary(ServletRegistration v) {
        return v.getClassName() + "('" + v.getName() + "')" + v.getInitParameters().keySet().stream().map(k -> k + "=" + (String)v.getInitParameters().get(k)).collect(Collectors.joining(","));
    }
}

