/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.docsys.core;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PathWalker {
    private static final Logger logger = LogManager.getLogger(PathWalker.class);
    public static DirectoryStream.Filter<Path> WALK_ALL = entry -> true;

    public static void walk(Path p, PathVisitor v) {
        PathWalker.walk(p, v, WALK_ALL);
    }

    public static List<Path> findAll(Path p) {
        Collect fileCollector = new Collect(true, false);
        PathWalker.walk(p, fileCollector);
        return fileCollector.get();
    }

    public static void walk(Path p, PathVisitor v, DirectoryStream.Filter<Path> filter) {
        try {
            FileSystemProvider provider = p.getFileSystem().provider();
            DirectoryStream<Path> paths = provider.newDirectoryStream(p, r -> true);
            ArrayList<Path> pathlist = new ArrayList<Path>();
            for (Path path : paths) {
                pathlist.add(path);
            }
            for (Path path : pathlist) {
                if (path.getFileSystem().provider().readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
                    v.preVisitDir(path);
                    PathWalker.walk(path, v, filter);
                    v.postVisitDir(path);
                    continue;
                }
                if (filter.accept(path)) {
                    v.preVisitFile(path);
                    v.visit(path);
                    v.postVisitFile(path);
                    continue;
                }
                logger.error("error");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface PathVisitor {
        public void visit(Path var1);

        default public void preVisitFile(Path path) {
        }

        default public void postVisitFile(Path path) {
        }

        default public void preVisitDir(Path path) {
        }

        default public void postVisitDir(Path path) {
        }
    }

    public static class Collect
    implements PathVisitor {
        private final List<Path> listing = new ArrayList<Path>();
        private final boolean collectFiles;
        private final boolean collectDirectories;

        public Collect(boolean collectFiles, boolean collectDirectories) {
            this.collectFiles = collectFiles;
            this.collectDirectories = collectDirectories;
        }

        public List<Path> get() {
            return this.listing;
        }

        @Override
        public void visit(Path p) {
        }

        @Override
        public void preVisitFile(Path path) {
            if (this.collectFiles) {
                this.listing.add(path);
            }
        }

        @Override
        public void preVisitDir(Path path) {
            if (this.collectDirectories) {
                this.listing.add(path);
            }
        }
    }
}

