/*
 * Decompiled with CFR 0.152.
 */
package io.nosqlbench.docsys.endpoints;

import io.nosqlbench.docsys.api.Docs;
import io.nosqlbench.docsys.api.DocsBinder;
import io.nosqlbench.docsys.api.DocsNameSpace;
import io.nosqlbench.docsys.api.WebServiceObject;
import io.nosqlbench.docsys.core.DocsysPathLoader;
import io.nosqlbench.docsys.core.PathWalker;
import io.nosqlbench.nb.annotations.Service;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Service(value=WebServiceObject.class, selector="docsys-markdown")
@Singleton
@Path(value="/services/docs/")
public class DocsysMarkdownEndpoint
implements WebServiceObject {
    private static final Logger logger = LogManager.getLogger(DocsysMarkdownEndpoint.class);
    private DocsBinder docsinfo;
    private DocsBinder enabled;
    private DocsBinder disabled;
    private final AtomicLong version = new AtomicLong(System.nanoTime());
    private final Set<String> enables = new HashSet<String>();

    @GET
    @Produces(value={"application/json"})
    @Path(value="version")
    public long getVersion() {
        return this.version.get();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="namespaces")
    public Map<String, Map<String, Set<java.nio.file.Path>>> getNamespaces(@QueryParam(value="enable") String enable, @QueryParam(value="reload") boolean reload) {
        if (enable != null && !enable.isEmpty()) {
            this.enables.clear();
            this.enables.addAll(List.of(enable.split("[, ;]")));
        }
        this.init(reload);
        this.enable(this.enables);
        return Map.of("enabled", this.enabled.getPathMap(), "disabled", this.disabled.getPathMap());
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="allfiles.csv")
    public String getAllfilesList(@QueryParam(value="reload") boolean reload) {
        this.init(reload);
        StringBuilder sb = new StringBuilder();
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            PathWalker.findAll(path).forEach(f -> sb.append(path.relativize((java.nio.file.Path)f)).append("\n"));
        }
        return sb.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="markdown.csv")
    public String getMarkdownList(@QueryParam(value="reload") boolean reload) {
        this.init(reload);
        StringBuilder sb = new StringBuilder();
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            PathWalker.findAll(path).forEach(f -> {
                if (f.toString().endsWith(".md")) {
                    sb.append(path.relativize((java.nio.file.Path)f)).append("\n");
                }
            });
        }
        return sb.toString();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    public List<String> listFiles(@QueryParam(value="reload") boolean reload) {
        this.init(reload);
        ArrayList<String> list = new ArrayList<String>();
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            PathWalker.findAll(path).forEach(f -> {
                java.nio.file.Path relative = path.relativize((java.nio.file.Path)f);
                list.add(relative.toString());
            });
        }
        return list;
    }

    @GET
    @Path(value="{pathspec:.*}")
    public Response getFileInPath(@PathParam(value="pathspec") String pathspec) {
        this.init(false);
        try {
            java.nio.file.Path path = this.findPath(pathspec);
            String contentType = Files.probeContentType(path);
            MediaType mediaType = MediaType.valueOf((String)contentType);
            return Response.ok((Object)Files.newBufferedReader(path), (MediaType)mediaType).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    public java.nio.file.Path findPath(String pathspec) {
        pathspec = URLDecoder.decode(pathspec, StandardCharsets.UTF_8);
        for (java.nio.file.Path path : this.enabled.getPaths()) {
            java.nio.file.Path resolved = path.resolve(pathspec);
            if (Files.isDirectory(resolved, new LinkOption[0])) {
                throw new RuntimeException("Path is a directory: '" + pathspec + "'");
            }
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        throw new RuntimeException("Unable to find any valid file at '" + pathspec + "'");
    }

    private void init(boolean reload) {
        if (reload) {
            this.enabled = null;
            this.disabled = null;
            this.docsinfo = null;
        }
        if (this.docsinfo == null) {
            this.docsinfo = DocsysPathLoader.loadDynamicPaths();
            this.version.set(System.nanoTime());
        }
        if (this.enabled == null || this.disabled == null) {
            this.enable(this.enables);
        }
    }

    private void enable(Set<String> enabled) {
        for (DocsNameSpace nsinfo : this.docsinfo) {
            if (!nsinfo.isEnabledByDefault() || this.disabled != null && this.disabled.getPathMap().containsKey(nsinfo.getName())) continue;
            this.enables.add(nsinfo.getName());
        }
        if (enabled.isEmpty()) {
            this.enabled = new Docs().merge(this.docsinfo);
            this.disabled = new Docs().asDocsBinder();
        } else {
            this.disabled = new Docs().merge(this.docsinfo);
            this.enabled = this.disabled.remove(enabled);
        }
    }
}

