/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.net.InetAddress;
import java.net.InetSocketAddress;

class AddressFormatter {
    AddressFormatter() {
    }

    static String nullSafeToString(Object address) {
        if (address instanceof InetAddress) {
            return AddressFormatter.nullSafeToString((InetAddress)address);
        }
        if (address instanceof InetSocketAddress) {
            return AddressFormatter.nullSafeToString((InetSocketAddress)address);
        }
        if (address instanceof String) {
            return address.toString();
        }
        return "";
    }

    static String nullSafeToString(InetAddress inetAddress) {
        return inetAddress != null ? inetAddress.getHostAddress() : null;
    }

    static String nullSafeToString(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress != null) {
            if (inetSocketAddress.isUnresolved()) {
                return String.format("%s:%s", AddressFormatter.nullSafeToString(inetSocketAddress.getHostName()), inetSocketAddress.getPort());
            }
            return String.format("%s:%s", AddressFormatter.nullSafeToString(inetSocketAddress.getAddress()), inetSocketAddress.getPort());
        }
        return null;
    }
}

