/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ArrayBackedRow;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.PreparedId;
import com.datastax.driver.core.ProtocolFeature;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.ConnectionException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.internal.com_google_common.util.concurrent.Futures;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import com.datastax.internal.com_google_common.util.concurrent.SettableFuture;
import com.datastax.internal.com_google_common.util.concurrent.Uninterruptibles;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ArrayBackedResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(ResultSet.class);
    private static final Queue<List<ByteBuffer>> EMPTY_QUEUE = new ArrayDeque<List<ByteBuffer>>(0);
    protected volatile ColumnDefinitions metadata;
    protected final Token.Factory tokenFactory;
    private final boolean wasApplied;
    protected final ProtocolVersion protocolVersion;
    protected final CodecRegistry codecRegistry;

    private ArrayBackedResultSet(ColumnDefinitions metadata, Token.Factory tokenFactory, List<ByteBuffer> firstRow, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        this.metadata = metadata;
        this.protocolVersion = protocolVersion;
        this.codecRegistry = codecRegistry;
        this.tokenFactory = tokenFactory;
        this.wasApplied = ArrayBackedResultSet.checkWasApplied(firstRow, metadata, protocolVersion);
    }

    static ArrayBackedResultSet fromMessage(Responses.Result msg, SessionManager session, ProtocolVersion protocolVersion, ExecutionInfo info, Statement statement) {
        switch (msg.kind) {
            case ROWS: {
                ColumnDefinitions columnDefs;
                Responses.Result.Rows r = (Responses.Result.Rows)msg;
                Statement actualStatement = statement;
                if (statement instanceof StatementWrapper) {
                    actualStatement = ((StatementWrapper)statement).getWrappedStatement();
                }
                if ((columnDefs = r.metadata.columns) == null) {
                    BoundStatement bs = (BoundStatement)actualStatement;
                    columnDefs = bs.preparedStatement().getPreparedId().resultSetMetadata.variables;
                } else {
                    MD5Digest newMetadataId = r.metadata.metadataId;
                    assert (!(actualStatement instanceof BoundStatement) || ProtocolFeature.PREPARED_METADATA_CHANGES.isSupportedBy(protocolVersion) || newMetadataId == null);
                    if (newMetadataId != null) {
                        BoundStatement bs = (BoundStatement)actualStatement;
                        PreparedId preparedId = bs.preparedStatement().getPreparedId();
                        if (preparedId.resultSetMetadata.variables != null) {
                            preparedId.resultSetMetadata = new PreparedId.PreparedMetadata(newMetadataId, columnDefs);
                        }
                    }
                }
                assert (columnDefs != null);
                Token.Factory tokenFactory = session == null ? null : session.getCluster().manager.metadata.tokenFactory();
                info = ArrayBackedResultSet.update(info, r, session, r.metadata.pagingState, protocolVersion, columnDefs.codecRegistry, statement);
                assert (r.metadata.pagingState == null || info != null);
                return r.metadata.pagingState == null ? new SinglePage(columnDefs, tokenFactory, protocolVersion, columnDefs.codecRegistry, r.data, info) : new MultiPage(columnDefs, tokenFactory, protocolVersion, columnDefs.codecRegistry, r.data, info, r.metadata.pagingState, session);
            }
            case VOID: 
            case SET_KEYSPACE: 
            case SCHEMA_CHANGE: {
                info = ArrayBackedResultSet.update(info, msg, session, null, protocolVersion, null, statement);
                return ArrayBackedResultSet.empty(info);
            }
            case PREPARED: {
                throw new RuntimeException("Prepared statement received when a ResultSet was expected");
            }
        }
        logger.error("Received unknown result type '{}'; returning empty result set", (Object)msg.kind);
        info = ArrayBackedResultSet.update(info, msg, session, null, protocolVersion, null, statement);
        return ArrayBackedResultSet.empty(info);
    }

    private static ExecutionInfo update(ExecutionInfo info, Responses.Result msg, SessionManager session, ByteBuffer pagingState, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, Statement statement) {
        if (info == null) {
            return null;
        }
        UUID tracingId = msg.getTracingId();
        QueryTrace trace = tracingId == null ? null : new QueryTrace(tracingId, session);
        return info.with(trace, msg.warnings, pagingState, statement, protocolVersion, codecRegistry);
    }

    private static ArrayBackedResultSet empty(ExecutionInfo info) {
        return new SinglePage(ColumnDefinitions.EMPTY, null, null, null, EMPTY_QUEUE, info);
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.metadata;
    }

    @Override
    public List<Row> all() {
        if (this.isExhausted()) {
            return Collections.emptyList();
        }
        ArrayList<Row> result = new ArrayList<Row>(this.getAvailableWithoutFetching());
        for (Row row : this) {
            result.add(row);
        }
        return result;
    }

    @Override
    public Iterator<Row> iterator() {
        return new Iterator<Row>(){

            @Override
            public boolean hasNext() {
                return !ArrayBackedResultSet.this.isExhausted();
            }

            @Override
            public Row next() {
                return ArrayBackedResultSet.this.one();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean wasApplied() {
        return this.wasApplied;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ResultSet[ exhausted: ").append(this.isExhausted());
        sb.append(", ").append(this.metadata).append(']');
        return sb.toString();
    }

    private static boolean checkWasApplied(List<ByteBuffer> firstRow, ColumnDefinitions metadata, ProtocolVersion protocolVersion) {
        if (firstRow == null) {
            return true;
        }
        int[] is = metadata.findAllIdx("[applied]");
        if (is == null) {
            return true;
        }
        int i = is[0];
        if (!DataType.cboolean().equals(metadata.getType(i))) {
            return true;
        }
        ByteBuffer value = firstRow.get(i);
        if (value == null || value.remaining() == 0) {
            return false;
        }
        return TypeCodec.cboolean().deserializeNoBoxing(value, protocolVersion);
    }

    private static class MultiPage
    extends ArrayBackedResultSet {
        private Queue<List<ByteBuffer>> currentPage;
        private final Queue<NextPage> nextPages = new ConcurrentLinkedQueue<NextPage>();
        private final Deque<ExecutionInfo> infos = new LinkedBlockingDeque<ExecutionInfo>();
        private volatile FetchingState fetchState;
        private final SessionManager session;

        private MultiPage(ColumnDefinitions metadata, Token.Factory tokenFactory, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, Queue<List<ByteBuffer>> rows, ExecutionInfo info, ByteBuffer pagingState, SessionManager session) {
            super(metadata, tokenFactory, rows.peek(), protocolVersion, codecRegistry);
            this.currentPage = rows;
            this.infos.offer(info);
            this.fetchState = new FetchingState(pagingState, null);
            this.session = session;
        }

        @Override
        public boolean isExhausted() {
            this.prepareNextRow();
            return this.currentPage.isEmpty();
        }

        @Override
        public Row one() {
            this.prepareNextRow();
            return ArrayBackedRow.fromData(this.metadata, this.tokenFactory, this.protocolVersion, this.currentPage.poll());
        }

        @Override
        public int getAvailableWithoutFetching() {
            int available = this.currentPage.size();
            for (NextPage page : this.nextPages) {
                available += page.data.size();
            }
            return available;
        }

        @Override
        public boolean isFullyFetched() {
            return this.fetchState == null;
        }

        private void prepareNextRow() {
            while (this.currentPage.isEmpty()) {
                FetchingState fetchingState = this.fetchState;
                NextPage nextPage = this.nextPages.poll();
                if (nextPage != null) {
                    if (nextPage.metadata != null) {
                        this.metadata = nextPage.metadata;
                    }
                    this.currentPage = nextPage.data;
                    continue;
                }
                if (fetchingState == null) {
                    return;
                }
                try {
                    this.session.checkNotInEventLoop();
                    Uninterruptibles.getUninterruptibly(this.fetchMoreResults());
                }
                catch (ExecutionException e) {
                    throw DriverThrowables.propagateCause(e);
                }
            }
        }

        @Override
        public ListenableFuture<ResultSet> fetchMoreResults() {
            return this.fetchMoreResults(this.fetchState);
        }

        private ListenableFuture<ResultSet> fetchMoreResults(FetchingState fetchState) {
            if (fetchState == null) {
                return Futures.immediateFuture(this);
            }
            if (fetchState.inProgress != null) {
                return fetchState.inProgress;
            }
            assert (fetchState.nextStart != null);
            ByteBuffer state = fetchState.nextStart;
            SettableFuture<ResultSet> future = SettableFuture.create();
            this.fetchState = new FetchingState(null, future);
            return this.queryNextPage(state, future);
        }

        private ListenableFuture<ResultSet> queryNextPage(ByteBuffer nextStart, final SettableFuture<ResultSet> future) {
            Statement statement = this.infos.peek().getStatement();
            assert (!(statement instanceof BatchStatement));
            final Message.Request request = this.session.makeRequestMessage(statement, nextStart);
            this.session.execute(new RequestHandler.Callback(){

                @Override
                public Message.Request request() {
                    return request;
                }

                @Override
                public void register(RequestHandler handler) {
                }

                @Override
                public void onSet(Connection connection, Message.Response response, ExecutionInfo info, Statement statement, long latency) {
                    try {
                        switch (response.type) {
                            case RESULT: {
                                Responses.Result rm = (Responses.Result)response;
                                if (rm.kind == Responses.Result.Kind.ROWS) {
                                    Responses.Result.Rows rows = (Responses.Result.Rows)rm;
                                    info = ArrayBackedResultSet.update(info, rm, MultiPage.this.session, rows.metadata.pagingState, MultiPage.this.protocolVersion, MultiPage.this.codecRegistry, statement);
                                    ColumnDefinitions newMetadata = null;
                                    if (rows.metadata.metadataId != null) {
                                        newMetadata = rows.metadata.columns;
                                        assert (statement instanceof BoundStatement);
                                        BoundStatement bs = (BoundStatement)statement;
                                        bs.preparedStatement().getPreparedId().resultSetMetadata = new PreparedId.PreparedMetadata(rows.metadata.metadataId, rows.metadata.columns);
                                    }
                                    MultiPage.this.nextPages.offer(new NextPage(newMetadata, rows.data));
                                    MultiPage.this.fetchState = rows.metadata.pagingState == null ? null : new FetchingState(rows.metadata.pagingState, null);
                                } else if (rm.kind == Responses.Result.Kind.VOID) {
                                    info = ArrayBackedResultSet.update(info, rm, MultiPage.this.session, null, MultiPage.this.protocolVersion, MultiPage.this.codecRegistry, statement);
                                    MultiPage.this.fetchState = null;
                                } else {
                                    logger.error("Received unknown result type '{}' during paging: ignoring message", (Object)rm.kind);
                                    connection.defunct(new ConnectionException(connection.endPoint, String.format("Got unexpected %s result response", new Object[]{rm.kind})));
                                    future.setException(new DriverInternalError(String.format("Got unexpected %s result response from %s", new Object[]{rm.kind, connection.endPoint})));
                                    return;
                                }
                                MultiPage.this.infos.offer(info);
                                future.set(MultiPage.this);
                                break;
                            }
                            case ERROR: {
                                future.setException(((Responses.Error)response).asException(connection.endPoint));
                                break;
                            }
                            default: {
                                connection.defunct(new ConnectionException(connection.endPoint, String.format("Got unexpected %s response", new Object[]{response.type})));
                                future.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", new Object[]{response.type, connection.endPoint})));
                                break;
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        future.setException(new DriverInternalError("Unexpected error while processing response from " + connection.endPoint, e));
                    }
                }

                @Override
                public void onSet(Connection connection, Message.Response response, long latency, int retryCount) {
                    this.onSet(connection, response, null, null, latency);
                }

                @Override
                public void onException(Connection connection, Exception exception, long latency, int retryCount) {
                    future.setException(exception);
                }

                @Override
                public boolean onTimeout(Connection connection, long latency, int retryCount) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int retryCount() {
                    return 0;
                }
            }, statement);
            return future;
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.infos.getLast();
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return new ArrayList<ExecutionInfo>(this.infos);
        }

        private static class NextPage {
            final ColumnDefinitions metadata;
            final Queue<List<ByteBuffer>> data;

            NextPage(ColumnDefinitions metadata, Queue<List<ByteBuffer>> data) {
                this.metadata = metadata;
                this.data = data;
            }
        }

        private static class FetchingState {
            public final ByteBuffer nextStart;
            public final ListenableFuture<ResultSet> inProgress;

            FetchingState(ByteBuffer nextStart, ListenableFuture<ResultSet> inProgress) {
                assert (nextStart == null != (inProgress == null));
                this.nextStart = nextStart;
                this.inProgress = inProgress;
            }
        }
    }

    private static class SinglePage
    extends ArrayBackedResultSet {
        private final Queue<List<ByteBuffer>> rows;
        private final ExecutionInfo info;

        private SinglePage(ColumnDefinitions metadata, Token.Factory tokenFactory, ProtocolVersion protocolVersion, CodecRegistry codecRegistry, Queue<List<ByteBuffer>> rows, ExecutionInfo info) {
            super(metadata, tokenFactory, rows.peek(), protocolVersion, codecRegistry);
            this.info = info;
            this.rows = rows;
        }

        @Override
        public boolean isExhausted() {
            return this.rows.isEmpty();
        }

        @Override
        public Row one() {
            return ArrayBackedRow.fromData(this.metadata, this.tokenFactory, this.protocolVersion, this.rows.poll());
        }

        @Override
        public int getAvailableWithoutFetching() {
            return this.rows.size();
        }

        @Override
        public boolean isFullyFetched() {
            return true;
        }

        @Override
        public ListenableFuture<ResultSet> fetchMoreResults() {
            return Futures.immediateFuture(this);
        }

        @Override
        public ExecutionInfo getExecutionInfo() {
            return this.info;
        }

        @Override
        public List<ExecutionInfo> getAllExecutionInfo() {
            return Collections.singletonList(this.info);
        }
    }
}

