/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.internal.com_google_common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;

class ConfigAntiPatternsFinder {
    ConfigAntiPatternsFinder() {
    }

    Map<String, String> findAntiPatterns(Cluster cluster) {
        HashMap<String, String> antiPatterns = new HashMap<String, String>();
        this.findLoadBalancingPolicyAntiPatterns(antiPatterns, cluster.getConfiguration().getPolicies().getLoadBalancingPolicy());
        this.findRetryPolicyAntiPatterns(antiPatterns, cluster.getConfiguration().getPolicies().getRetryPolicy());
        return antiPatterns;
    }

    private void findRetryPolicyAntiPatterns(Map<String, String> antiPatterns, RetryPolicy retryPolicy) {
        if (retryPolicy instanceof DowngradingConsistencyRetryPolicy) {
            antiPatterns.put("downgradingConsistency", "Downgrading consistency retry policy in use");
        }
    }

    @VisibleForTesting
    void findLoadBalancingPolicyAntiPatterns(Map<String, String> antiPatterns, LoadBalancingPolicy loadBalancingPolicy) {
        if (loadBalancingPolicy instanceof ChainableLoadBalancingPolicy) {
            this.findLoadBalancingPolicyAntiPatterns(antiPatterns, ((ChainableLoadBalancingPolicy)loadBalancingPolicy).getChildPolicy());
        }
        if (loadBalancingPolicy instanceof DCAwareRoundRobinPolicy) {
            DCAwareRoundRobinPolicy dcAwareRoundRobinPolicy = (DCAwareRoundRobinPolicy)loadBalancingPolicy;
            if (dcAwareRoundRobinPolicy.isContactPointsMultipleDCs()) {
                antiPatterns.put("contactPointsMultipleDCs", "Contact points contain hosts from multiple data centers");
            }
            if (dcAwareRoundRobinPolicy.isUseRemoteHostsForFailover()) {
                antiPatterns.put("useRemoteHosts", "Using remote hosts for failover");
            }
        }
    }
}

