/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ExtendedAuthProvider;
import com.datastax.driver.core.ExtendedRemoteEndpointAwareSslOptions;
import com.datastax.driver.core.InsightsOptions;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SniEndPointFactory;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.ThreadingOptions;
import com.datastax.driver.core.policies.Policies;
import com.datastax.internal.com_google_common.base.Joiner;
import java.util.ArrayList;

public class Configuration {
    private final Policies policies;
    private final ProtocolOptions protocolOptions;
    private final PoolingOptions poolingOptions;
    private final SocketOptions socketOptions;
    private final MetricsOptions metricsOptions;
    private final QueryOptions queryOptions;
    private final ThreadingOptions threadingOptions;
    private final NettyOptions nettyOptions;
    private final CodecRegistry codecRegistry;
    private final InsightsOptions insightsOptions;
    private final String defaultKeyspace;

    public static Builder builder() {
        return new Builder();
    }

    private Configuration(Policies policies, ProtocolOptions protocolOptions, PoolingOptions poolingOptions, SocketOptions socketOptions, MetricsOptions metricsOptions, QueryOptions queryOptions, ThreadingOptions threadingOptions, NettyOptions nettyOptions, CodecRegistry codecRegistry, InsightsOptions insightsOptions, String defaultKeyspace) {
        this.policies = policies;
        this.protocolOptions = protocolOptions;
        this.poolingOptions = poolingOptions;
        this.socketOptions = socketOptions;
        this.metricsOptions = metricsOptions;
        this.queryOptions = queryOptions;
        this.threadingOptions = threadingOptions;
        this.nettyOptions = nettyOptions;
        this.codecRegistry = codecRegistry;
        this.insightsOptions = insightsOptions;
        this.defaultKeyspace = defaultKeyspace;
    }

    protected Configuration(Configuration toCopy) {
        this(toCopy.getPolicies(), toCopy.getProtocolOptions(), toCopy.getPoolingOptions(), toCopy.getSocketOptions(), toCopy.getMetricsOptions(), toCopy.getQueryOptions(), toCopy.getThreadingOptions(), toCopy.getNettyOptions(), toCopy.getCodecRegistry(), toCopy.getInsightsOptions(), toCopy.getDefaultKeyspace());
    }

    void register(Cluster.Manager manager) {
        this.protocolOptions.register(manager);
        this.poolingOptions.register(manager);
        this.queryOptions.register(manager);
        this.policies.getEndPointFactory().init(manager.getCluster());
        this.checkPoliciesIfSni();
    }

    private void checkPoliciesIfSni() {
        if (this.policies.getEndPointFactory() instanceof SniEndPointFactory) {
            AuthProvider authProvider;
            SSLOptions sslOptions = this.protocolOptions.getSSLOptions();
            ArrayList<String> errors = new ArrayList<String>();
            if (sslOptions != null && !(sslOptions instanceof ExtendedRemoteEndpointAwareSslOptions)) {
                errors.add(String.format("the configured %s must implement %s", SSLOptions.class.getSimpleName(), ExtendedRemoteEndpointAwareSslOptions.class.getSimpleName()));
            }
            if ((authProvider = this.protocolOptions.getAuthProvider()) != null && !(authProvider instanceof ExtendedAuthProvider)) {
                errors.add(String.format("the configured %s must implement %s", AuthProvider.class.getSimpleName(), ExtendedAuthProvider.class.getSimpleName()));
            }
            if (!errors.isEmpty()) {
                throw new IllegalStateException("Configuration error: if SNI endpoints are in use, " + Joiner.on(',').join(errors));
            }
        }
    }

    public Policies getPolicies() {
        return this.policies;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public ProtocolOptions getProtocolOptions() {
        return this.protocolOptions;
    }

    public PoolingOptions getPoolingOptions() {
        return this.poolingOptions;
    }

    public MetricsOptions getMetricsOptions() {
        return this.metricsOptions;
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public ThreadingOptions getThreadingOptions() {
        return this.threadingOptions;
    }

    public NettyOptions getNettyOptions() {
        return this.nettyOptions;
    }

    public String getDefaultKeyspace() {
        return this.defaultKeyspace;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    InsightsOptions getInsightsOptions() {
        return this.insightsOptions;
    }

    public static class Builder {
        private Policies policies;
        private ProtocolOptions protocolOptions;
        private PoolingOptions poolingOptions;
        private SocketOptions socketOptions;
        private MetricsOptions metricsOptions;
        private QueryOptions queryOptions;
        private ThreadingOptions threadingOptions;
        private NettyOptions nettyOptions;
        private CodecRegistry codecRegistry;
        private InsightsOptions insightsOptions;
        private String defaultKeyspace;

        public Builder withPolicies(Policies policies) {
            this.policies = policies;
            return this;
        }

        public Builder withInsightsOptions(InsightsOptions insightsOptions) {
            this.insightsOptions = insightsOptions;
            return this;
        }

        public Builder withProtocolOptions(ProtocolOptions protocolOptions) {
            this.protocolOptions = protocolOptions;
            return this;
        }

        public Builder withPoolingOptions(PoolingOptions poolingOptions) {
            this.poolingOptions = poolingOptions;
            return this;
        }

        public Builder withSocketOptions(SocketOptions socketOptions) {
            this.socketOptions = socketOptions;
            return this;
        }

        public Builder withMetricsOptions(MetricsOptions metricsOptions) {
            this.metricsOptions = metricsOptions;
            return this;
        }

        public Builder withQueryOptions(QueryOptions queryOptions) {
            this.queryOptions = queryOptions;
            return this;
        }

        public Builder withThreadingOptions(ThreadingOptions threadingOptions) {
            this.threadingOptions = threadingOptions;
            return this;
        }

        public Builder withNettyOptions(NettyOptions nettyOptions) {
            this.nettyOptions = nettyOptions;
            return this;
        }

        public Builder withCodecRegistry(CodecRegistry codecRegistry) {
            this.codecRegistry = codecRegistry;
            return this;
        }

        public Builder withDefaultKeyspace(String keyspace) {
            this.defaultKeyspace = keyspace;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.policies != null ? this.policies : Policies.builder().build(), this.protocolOptions != null ? this.protocolOptions : new ProtocolOptions(), this.poolingOptions != null ? this.poolingOptions : new PoolingOptions(), this.socketOptions != null ? this.socketOptions : new SocketOptions(), this.metricsOptions != null ? this.metricsOptions : new MetricsOptions(), this.queryOptions != null ? this.queryOptions : new QueryOptions(), this.threadingOptions != null ? this.threadingOptions : new ThreadingOptions(), this.nettyOptions != null ? this.nettyOptions : NettyOptions.DEFAULT_INSTANCE, this.codecRegistry != null ? this.codecRegistry : CodecRegistry.DEFAULT_INSTANCE, this.insightsOptions != null ? this.insightsOptions : new InsightsOptions(), this.defaultKeyspace);
        }
    }
}

