/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import java.util.HashSet;
import java.util.Set;

class DataCentersFinder {
    DataCentersFinder() {
    }

    Set<String> getDataCenters(Cluster cluster) {
        int remoteConnectionsLength = cluster.getConfiguration().getPoolingOptions().getCoreConnectionsPerHost(HostDistance.REMOTE);
        HashSet<String> dataCenters = new HashSet<String>();
        for (Host h : cluster.getMetadata().getAllHosts()) {
            HostDistance distance = cluster.getConfiguration().getPolicies().getLoadBalancingPolicy().distance(h);
            if (!distance.equals((Object)HostDistance.LOCAL) && (!distance.equals((Object)HostDistance.REMOTE) || remoteConnectionsLength <= 0)) continue;
            dataCenters.add(h.getDatacenter());
        }
        return dataCenters;
    }

    String getLocalDataCenter(Cluster cluster) {
        for (Host h : cluster.getMetadata().getAllHosts()) {
            HostDistance distance = cluster.getConfiguration().getPolicies().getLoadBalancingPolicy().distance(h);
            if (!distance.equals((Object)HostDistance.LOCAL)) continue;
            return h.getDatacenter();
        }
        return null;
    }
}

