/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataTypeClassNameParser;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.utils.MoreObjects;
import com.datastax.internal.com_google_common.collect.ImmutableList;
import com.datastax.internal.com_google_common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DataType {
    private static final Map<Name, DataType> primitiveTypeMap = new EnumMap<Name, DataType>(Name.class);
    private static final Set<DataType> primitiveTypeSet;
    protected final Name name;

    protected DataType(Name name) {
        this.name = name;
    }

    static DataType decode(ByteBuf buffer, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        Name name = Name.fromProtocolId(buffer.readUnsignedShort());
        switch (name) {
            case CUSTOM: {
                String className = CBUtil.readString(buffer);
                if (DataTypeClassNameParser.isDuration(className)) {
                    return DataType.duration();
                }
                if (DataTypeClassNameParser.isUserType(className) || DataTypeClassNameParser.isTupleType(className)) {
                    return DataTypeClassNameParser.parseOne(className, protocolVersion, codecRegistry);
                }
                return DataType.custom(className);
            }
            case LIST: {
                return DataType.list(DataType.decode(buffer, protocolVersion, codecRegistry));
            }
            case SET: {
                return DataType.set(DataType.decode(buffer, protocolVersion, codecRegistry));
            }
            case MAP: {
                DataType keys = DataType.decode(buffer, protocolVersion, codecRegistry);
                DataType values = DataType.decode(buffer, protocolVersion, codecRegistry);
                return DataType.map(keys, values);
            }
            case UDT: {
                String keyspace = CBUtil.readString(buffer);
                String type = CBUtil.readString(buffer);
                int nFields = buffer.readShort() & 0xFFFF;
                ArrayList<UserType.Field> fields = new ArrayList<UserType.Field>(nFields);
                for (int i = 0; i < nFields; ++i) {
                    String fieldName = CBUtil.readString(buffer);
                    DataType fieldType = DataType.decode(buffer, protocolVersion, codecRegistry);
                    fields.add(new UserType.Field(fieldName, fieldType));
                }
                return new UserType(keyspace, type, false, fields, protocolVersion, codecRegistry);
            }
            case TUPLE: {
                int nFields = buffer.readShort() & 0xFFFF;
                ArrayList<DataType> types = new ArrayList<DataType>(nFields);
                for (int i = 0; i < nFields; ++i) {
                    types.add(DataType.decode(buffer, protocolVersion, codecRegistry));
                }
                return new TupleType(types, protocolVersion, codecRegistry);
            }
        }
        return primitiveTypeMap.get((Object)name);
    }

    public static DataType ascii() {
        return primitiveTypeMap.get((Object)Name.ASCII);
    }

    public static DataType bigint() {
        return primitiveTypeMap.get((Object)Name.BIGINT);
    }

    public static DataType blob() {
        return primitiveTypeMap.get((Object)Name.BLOB);
    }

    public static DataType cboolean() {
        return primitiveTypeMap.get((Object)Name.BOOLEAN);
    }

    public static DataType counter() {
        return primitiveTypeMap.get((Object)Name.COUNTER);
    }

    public static DataType decimal() {
        return primitiveTypeMap.get((Object)Name.DECIMAL);
    }

    public static DataType cdouble() {
        return primitiveTypeMap.get((Object)Name.DOUBLE);
    }

    public static DataType cfloat() {
        return primitiveTypeMap.get((Object)Name.FLOAT);
    }

    public static DataType inet() {
        return primitiveTypeMap.get((Object)Name.INET);
    }

    public static DataType tinyint() {
        return primitiveTypeMap.get((Object)Name.TINYINT);
    }

    public static DataType smallint() {
        return primitiveTypeMap.get((Object)Name.SMALLINT);
    }

    public static DataType cint() {
        return primitiveTypeMap.get((Object)Name.INT);
    }

    public static DataType text() {
        return primitiveTypeMap.get((Object)Name.TEXT);
    }

    public static DataType timestamp() {
        return primitiveTypeMap.get((Object)Name.TIMESTAMP);
    }

    public static DataType date() {
        return primitiveTypeMap.get((Object)Name.DATE);
    }

    public static DataType time() {
        return primitiveTypeMap.get((Object)Name.TIME);
    }

    public static DataType uuid() {
        return primitiveTypeMap.get((Object)Name.UUID);
    }

    public static DataType varchar() {
        return primitiveTypeMap.get((Object)Name.VARCHAR);
    }

    public static DataType varint() {
        return primitiveTypeMap.get((Object)Name.VARINT);
    }

    public static DataType timeuuid() {
        return primitiveTypeMap.get((Object)Name.TIMEUUID);
    }

    public static CollectionType list(DataType elementType, boolean frozen) {
        return new CollectionType(Name.LIST, ImmutableList.of(elementType), frozen);
    }

    public static CollectionType list(DataType elementType) {
        return DataType.list(elementType, false);
    }

    public static CollectionType frozenList(DataType elementType) {
        return DataType.list(elementType, true);
    }

    public static CollectionType set(DataType elementType, boolean frozen) {
        return new CollectionType(Name.SET, ImmutableList.of(elementType), frozen);
    }

    public static CollectionType set(DataType elementType) {
        return DataType.set(elementType, false);
    }

    public static CollectionType frozenSet(DataType elementType) {
        return DataType.set(elementType, true);
    }

    public static CollectionType map(DataType keyType, DataType valueType, boolean frozen) {
        return new CollectionType(Name.MAP, ImmutableList.of(keyType, valueType), frozen);
    }

    public static CollectionType map(DataType keyType, DataType valueType) {
        return DataType.map(keyType, valueType, false);
    }

    public static CollectionType frozenMap(DataType keyType, DataType valueType) {
        return DataType.map(keyType, valueType, true);
    }

    public static CustomType custom(String typeClassName) {
        if (typeClassName == null) {
            throw new NullPointerException();
        }
        return new CustomType(Name.CUSTOM, typeClassName);
    }

    public static DataType duration() {
        return primitiveTypeMap.get((Object)Name.DURATION);
    }

    public Name getName() {
        return this.name;
    }

    public abstract boolean isFrozen();

    public boolean isCollection() {
        return this instanceof CollectionType;
    }

    public List<DataType> getTypeArguments() {
        return Collections.emptyList();
    }

    public static Set<DataType> allPrimitiveTypes() {
        return primitiveTypeSet;
    }

    public String asFunctionParameterString() {
        return this.toString();
    }

    static {
        primitiveTypeMap.put(Name.ASCII, new NativeType(Name.ASCII));
        primitiveTypeMap.put(Name.BIGINT, new NativeType(Name.BIGINT));
        primitiveTypeMap.put(Name.BLOB, new NativeType(Name.BLOB));
        primitiveTypeMap.put(Name.BOOLEAN, new NativeType(Name.BOOLEAN));
        primitiveTypeMap.put(Name.COUNTER, new NativeType(Name.COUNTER));
        primitiveTypeMap.put(Name.DECIMAL, new NativeType(Name.DECIMAL));
        primitiveTypeMap.put(Name.DOUBLE, new NativeType(Name.DOUBLE));
        primitiveTypeMap.put(Name.FLOAT, new NativeType(Name.FLOAT));
        primitiveTypeMap.put(Name.INET, new NativeType(Name.INET));
        primitiveTypeMap.put(Name.INT, new NativeType(Name.INT));
        primitiveTypeMap.put(Name.TEXT, new NativeType(Name.TEXT));
        primitiveTypeMap.put(Name.TIMESTAMP, new NativeType(Name.TIMESTAMP));
        primitiveTypeMap.put(Name.UUID, new NativeType(Name.UUID));
        primitiveTypeMap.put(Name.VARCHAR, new NativeType(Name.VARCHAR));
        primitiveTypeMap.put(Name.VARINT, new NativeType(Name.VARINT));
        primitiveTypeMap.put(Name.TIMEUUID, new NativeType(Name.TIMEUUID));
        primitiveTypeMap.put(Name.SMALLINT, new NativeType(Name.SMALLINT));
        primitiveTypeMap.put(Name.TINYINT, new NativeType(Name.TINYINT));
        primitiveTypeMap.put(Name.DATE, new NativeType(Name.DATE));
        primitiveTypeMap.put(Name.TIME, new NativeType(Name.TIME));
        primitiveTypeMap.put(Name.DURATION, new NativeType(Name.DURATION));
        primitiveTypeSet = ImmutableSet.copyOf(primitiveTypeMap.values());
    }

    public static class CustomType
    extends DataType {
        private final String customClassName;

        private CustomType(Name name, String className) {
            super(name);
            this.customClassName = className;
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        public String getCustomTypeClassName() {
            return this.customClassName;
        }

        public final int hashCode() {
            return MoreObjects.hashCode(new Object[]{this.name, this.customClassName});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof CustomType)) {
                return false;
            }
            CustomType d = (CustomType)o;
            return this.name == d.name && MoreObjects.equal(this.customClassName, d.customClassName);
        }

        public String toString() {
            return String.format("'%s'", this.customClassName);
        }
    }

    public static class CollectionType
    extends DataType {
        private final List<DataType> typeArguments;
        private boolean frozen;

        private CollectionType(Name name, List<DataType> typeArguments, boolean frozen) {
            super(name);
            this.typeArguments = typeArguments;
            this.frozen = frozen;
        }

        @Override
        public boolean isFrozen() {
            return this.frozen;
        }

        @Override
        public List<DataType> getTypeArguments() {
            return this.typeArguments;
        }

        public final int hashCode() {
            return MoreObjects.hashCode(new Object[]{this.name, this.typeArguments});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof CollectionType)) {
                return false;
            }
            CollectionType d = (CollectionType)o;
            return this.name == d.name && this.typeArguments.equals(d.typeArguments);
        }

        public String toString() {
            if (this.name == Name.MAP) {
                String template = this.frozen ? "frozen<%s<%s, %s>>" : "%s<%s, %s>";
                return String.format(template, new Object[]{this.name, this.typeArguments.get(0), this.typeArguments.get(1)});
            }
            String template = this.frozen ? "frozen<%s<%s>>" : "%s<%s>";
            return String.format(template, new Object[]{this.name, this.typeArguments.get(0)});
        }

        @Override
        public String asFunctionParameterString() {
            if (this.name == Name.MAP) {
                String template = "%s<%s, %s>";
                return String.format(template, new Object[]{this.name, this.typeArguments.get(0).asFunctionParameterString(), this.typeArguments.get(1).asFunctionParameterString()});
            }
            String template = "%s<%s>";
            return String.format(template, new Object[]{this.name, this.typeArguments.get(0).asFunctionParameterString()});
        }
    }

    public static class NativeType
    extends DataType {
        private NativeType(Name name) {
            super(name);
        }

        @Override
        public boolean isFrozen() {
            return false;
        }

        public final int hashCode() {
            return this.name == Name.TEXT ? Name.VARCHAR.hashCode() : this.name.hashCode();
        }

        public final boolean equals(Object o) {
            if (!(o instanceof NativeType)) {
                return false;
            }
            NativeType that = (NativeType)o;
            return this.name.isCompatibleWith(that.name);
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static enum Name {
        CUSTOM(0),
        ASCII(1),
        BIGINT(2),
        BLOB(3),
        BOOLEAN(4),
        COUNTER(5),
        DECIMAL(6),
        DOUBLE(7),
        FLOAT(8),
        INT(9),
        TEXT(10){

            @Override
            public boolean isCompatibleWith(Name that) {
                return this == that || that == VARCHAR;
            }
        }
        ,
        TIMESTAMP(11),
        UUID(12),
        VARCHAR(13){

            @Override
            public boolean isCompatibleWith(Name that) {
                return this == that || that == TEXT;
            }
        }
        ,
        VARINT(14),
        TIMEUUID(15),
        INET(16),
        DATE(17, ProtocolVersion.V4),
        TIME(18, ProtocolVersion.V4),
        SMALLINT(19, ProtocolVersion.V4),
        TINYINT(20, ProtocolVersion.V4),
        DURATION(21, ProtocolVersion.V5),
        LIST(32),
        MAP(33),
        SET(34),
        UDT(48, ProtocolVersion.V3),
        TUPLE(49, ProtocolVersion.V3);

        final int protocolId;
        final ProtocolVersion minProtocolVersion;
        private static final Name[] nameToIds;

        private Name(int protocolId) {
            this(protocolId, ProtocolVersion.V1);
        }

        private Name(int protocolId, ProtocolVersion minProtocolVersion) {
            this.protocolId = protocolId;
            this.minProtocolVersion = minProtocolVersion;
        }

        static Name fromProtocolId(int id) {
            Name name = nameToIds[id];
            if (name == null) {
                throw new DriverInternalError("Unknown data type protocol id: " + id);
            }
            return name;
        }

        public boolean isCompatibleWith(Name that) {
            return this == that;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }

        static {
            int maxCode = -1;
            for (Name name : Name.values()) {
                maxCode = Math.max(maxCode, name.protocolId);
            }
            nameToIds = new Name[maxCode + 1];
            for (Name name : Name.values()) {
                if (nameToIds[name.protocolId] != null) {
                    throw new IllegalStateException("Duplicate Id");
                }
                Name.nameToIds[name.protocolId] = name;
            }
        }
    }
}

