/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AsyncContinuousPagingResult;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ContinuousPagingResult;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.Row;
import com.datastax.internal.com_google_common.collect.AbstractIterator;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import com.datastax.internal.com_google_common.util.concurrent.Uninterruptibles;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;

class DefaultContinuousPagingResult
implements ContinuousPagingResult {
    private final RowIterator iterator;
    private final ColumnDefinitions columnDefinitions;

    DefaultContinuousPagingResult(ListenableFuture<AsyncContinuousPagingResult> firstPageFuture) {
        try {
            AsyncContinuousPagingResult result = Uninterruptibles.getUninterruptibly(firstPageFuture);
            this.iterator = new RowIterator(result);
            this.columnDefinitions = result.getColumnDefinitions();
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterator;
    }

    @Override
    public ColumnDefinitions getColumnDefinitions() {
        return this.columnDefinitions;
    }

    @Override
    public void cancel() {
        this.iterator.cancel();
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.iterator.getExecutionInfo();
    }

    private static class RowIterator
    extends AbstractIterator<Row> {
        private AsyncContinuousPagingResult currentResult;
        private Iterator<Row> currentRows;
        private boolean cancelled;

        private RowIterator(AsyncContinuousPagingResult result) {
            this.currentResult = result;
            this.currentRows = result.currentPage().iterator();
        }

        @Override
        protected Row computeNext() {
            this.maybeFetchNextResult();
            return this.currentRows.hasNext() ? this.currentRows.next() : (Row)this.endOfData();
        }

        private void maybeFetchNextResult() {
            if (!(this.currentRows.hasNext() || this.cancelled || this.currentResult.isLast())) {
                try {
                    this.currentResult = Uninterruptibles.getUninterruptibly(this.currentResult.nextPage());
                    this.currentRows = this.currentResult.currentPage().iterator();
                }
                catch (ExecutionException e) {
                    throw DriverThrowables.propagateCause(e);
                }
            }
        }

        private ExecutionInfo getExecutionInfo() {
            return this.currentResult.getExecutionInfo();
        }

        private void cancel() {
            this.currentResult.cancel();
            this.cancelled = true;
        }
    }
}

