/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataCentersFinder;
import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.PackageUtil;
import com.datastax.driver.core.SpeculativeExecutionInfoFinder;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.graph.GraphOptions;
import java.util.HashMap;
import java.util.Map;

class ExecutionProfilesInfoFinder {
    private SpeculativeExecutionInfoFinder speculativeExecutionInfoFinder;
    private DataCentersFinder dataCentersFinder;

    ExecutionProfilesInfoFinder(SpeculativeExecutionInfoFinder speculativeExecutionInfoFinder, DataCentersFinder dataCentersFinder) {
        this.speculativeExecutionInfoFinder = speculativeExecutionInfoFinder;
        this.dataCentersFinder = dataCentersFinder;
    }

    Map<String, InsightsSchema.SpecificExecutionProfile> getExecutionProfilesInfo(Cluster cluster) {
        HashMap<String, InsightsSchema.SpecificExecutionProfile> executionProfiles = new HashMap<String, InsightsSchema.SpecificExecutionProfile>();
        Class<?> loadBalancingClass = cluster.getManager().loadBalancingPolicy().getClass();
        InsightsSchema.SpecificExecutionProfile defaultExecutionProfile = new InsightsSchema.SpecificExecutionProfile(cluster.getConfiguration().getSocketOptions().getReadTimeoutMillis(), new InsightsSchema.LoadBalancingInfo(cluster.getManager().loadBalancingPolicy().getClass().getSimpleName(), PackageUtil.getNamespace(loadBalancingClass), this.maybeSetLocalDc(cluster)), this.speculativeExecutionInfoFinder.getSpeculativeExecutionInfo(cluster.getManager().speculativeExecutionPolicy()), cluster.getConfiguration().getQueryOptions().getConsistencyLevel().toString(), cluster.getConfiguration().getQueryOptions().getSerialConsistencyLevel().toString(), this.getGraphOptions(cluster));
        executionProfiles.put("default", defaultExecutionProfile);
        return executionProfiles;
    }

    private Map<String, Object> maybeSetLocalDc(Cluster cluster) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String localDataCenter = this.dataCentersFinder.getLocalDataCenter(cluster);
        if (localDataCenter != null) {
            options.put("localDataCenter", localDataCenter);
        }
        return options;
    }

    private Map<String, Object> getGraphOptions(Cluster cluster) {
        HashMap<String, Object> graphOptionsMap = new HashMap<String, Object>();
        if (cluster instanceof DseCluster) {
            DseCluster dseCluster = (DseCluster)cluster;
            GraphOptions graphOptions = dseCluster.getConfiguration().getGraphOptions();
            graphOptionsMap.put("language", graphOptions.getGraphLanguage());
            graphOptionsMap.put("source", graphOptions.getGraphSource());
        }
        return graphOptionsMap;
    }
}

