/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.internal.com_google_common.base.Function;
import com.datastax.internal.com_google_common.collect.BiMap;
import com.datastax.internal.com_google_common.collect.Maps;
import com.datastax.internal.com_google_common.reflect.TypeToken;
import com.datastax.internal.com_google_common.util.concurrent.AsyncFunction;
import com.datastax.internal.com_google_common.util.concurrent.FutureCallback;
import com.datastax.internal.com_google_common.util.concurrent.FutureFallback;
import com.datastax.internal.com_google_common.util.concurrent.Futures;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import com.datastax.internal.com_google_common.util.concurrent.MoreExecutors;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuavaCompatibility {
    private static final Logger logger = LoggerFactory.getLogger(GuavaCompatibility.class);
    public static final GuavaCompatibility INSTANCE = GuavaCompatibility.selectImplementation();

    public static void init() {
    }

    public abstract <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> var1, AsyncFunction<Throwable, V> var2);

    public abstract <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> var1, AsyncFunction<Throwable, V> var2, Executor var3);

    public <I> void addCallback(ListenableFuture<I> input, FutureCallback<? super I> callback) {
        this.addCallback(input, callback, this.sameThreadExecutor());
    }

    public <I> void addCallback(ListenableFuture<I> input, FutureCallback<? super I> callback, Executor executor) {
        Futures.addCallback(input, callback, executor);
    }

    public <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function) {
        return this.transform(input, function, this.sameThreadExecutor());
    }

    public <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        return Futures.transform(input, function, executor);
    }

    public abstract <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> var1, AsyncFunction<? super I, ? extends O> var2);

    public abstract <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> var1, AsyncFunction<? super I, ? extends O> var2, Executor var3);

    public abstract boolean isSupertypeOf(TypeToken<?> var1, TypeToken<?> var2);

    public abstract Executor sameThreadExecutor();

    private static GuavaCompatibility selectImplementation() {
        if (GuavaCompatibility.isGuava_19_0_OrHigher()) {
            logger.info("Detected Guava >= 19 in the classpath, using modern compatibility layer");
            return new Version19OrHigher();
        }
        if (GuavaCompatibility.isGuava_16_0_1_OrHigher()) {
            logger.info("Detected Guava < 19 in the classpath, using legacy compatibility layer");
            return new Version18OrLower();
        }
        throw new DriverInternalError("Detected incompatible version of Guava in the classpath. You need 16.0.1 or higher.");
    }

    private static boolean isGuava_19_0_OrHigher() {
        return GuavaCompatibility.methodExists(Futures.class, "transformAsync", ListenableFuture.class, AsyncFunction.class, Executor.class);
    }

    private static boolean isGuava_16_0_1_OrHigher() {
        ParameterizedType pType;
        Type[] types;
        if (!GuavaCompatibility.methodExists(Maps.class, "asConverter", BiMap.class)) {
            return false;
        }
        boolean resolved = false;
        TypeToken<Map<String, String>> mapOfString = TypeTokens.mapOf(String.class, String.class);
        Type type = mapOfString.getType();
        if (type instanceof ParameterizedType && (types = (pType = (ParameterizedType)type).getActualTypeArguments()).length == 2) {
            TypeToken<?> valueType = TypeToken.of(types[1]);
            resolved = valueType.getRawType().equals(String.class);
        }
        if (!resolved) {
            logger.debug("Detected Guava issue #1635 which indicates that version 16.0 is in the classpath");
        }
        return resolved;
    }

    private static boolean methodExists(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        try {
            declaringClass.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (Exception e) {
            logger.debug("Error while checking existence of method " + declaringClass.getSimpleName() + "." + methodName, e);
            return false;
        }
    }

    private static class Version19OrHigher
    extends GuavaCompatibility {
        private Version19OrHigher() {
        }

        @Override
        public <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, AsyncFunction<Throwable, V> fallback) {
            return this.withFallback(input, fallback, this.sameThreadExecutor());
        }

        @Override
        public <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, AsyncFunction<Throwable, V> fallback, Executor executor) {
            return Futures.catchingAsync(input, Throwable.class, fallback, executor);
        }

        @Override
        public <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
            return this.transformAsync(input, function, this.sameThreadExecutor());
        }

        @Override
        public <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
            return Futures.transformAsync(input, function, executor);
        }

        @Override
        public boolean isSupertypeOf(TypeToken<?> target, TypeToken<?> argument) {
            return target.isSupertypeOf(argument);
        }

        @Override
        public Executor sameThreadExecutor() {
            return MoreExecutors.directExecutor();
        }
    }

    private static class Version18OrLower
    extends GuavaCompatibility {
        private Version18OrLower() {
        }

        @Override
        public <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, final AsyncFunction<Throwable, V> fallback) {
            return Futures.withFallback(input, new FutureFallback<V>(){

                @Override
                public ListenableFuture<V> create(Throwable t) throws Exception {
                    return fallback.apply(t);
                }
            });
        }

        @Override
        public <V> ListenableFuture<V> withFallback(ListenableFuture<? extends V> input, final AsyncFunction<Throwable, V> fallback, Executor executor) {
            return Futures.withFallback(input, new FutureFallback<V>(){

                @Override
                public ListenableFuture<V> create(Throwable t) throws Exception {
                    return fallback.apply(t);
                }
            }, executor);
        }

        @Override
        public <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function) {
            return Futures.transform(input, function);
        }

        @Override
        public <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
            return Futures.transform(input, function, executor);
        }

        @Override
        public boolean isSupertypeOf(TypeToken<?> target, TypeToken<?> argument) {
            return target.isAssignableFrom(argument);
        }

        @Override
        public Executor sameThreadExecutor() {
            return MoreExecutors.sameThreadExecutor();
        }
    }
}

