/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AddressFormatter;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConfigAntiPatternsFinder;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.DataCentersFinder;
import com.datastax.driver.core.DelegatingCluster;
import com.datastax.driver.core.ExecutionProfilesInfoFinder;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.InsightsConfiguration;
import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.InsightsSupportVerifier;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.PackageUtil;
import com.datastax.driver.core.PlatformInfoFinder;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ReconnectionPolicyInfoFinder;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SpeculativeExecutionInfoFinder;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.InsightEventFormatException;
import com.datastax.driver.dse.DseCluster;
import com.datastax.internal.com_google_common.annotations.VisibleForTesting;
import com.datastax.internal.com_google_common.base.Supplier;
import com.datastax.internal.com_google_common.collect.ImmutableMap;
import com.datastax.internal.com_google_common.util.concurrent.AsyncFunction;
import com.datastax.internal.com_google_common.util.concurrent.Futures;
import com.datastax.internal.com_google_common.util.concurrent.ListenableFuture;
import com.datastax.shaded.jackson.core.JsonProcessingException;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InsightsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsightsClient.class);
    private static final String STARTUP_MESSAGE_NAME = "driver.startup";
    private static final String STATUS_MESSAGE_NAME = "driver.status";
    private static final String REPORT_INSIGHT_RPC = "CALL InsightsRpc.reportInsight(?)";
    private static final Map<String, String> TAGS = ImmutableMap.of("language", "java");
    private static final String STARTUP_VERSION_1_ID = "v1";
    private static final String STATUS_VERSION_1_ID = "v1";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int MAX_NUMBER_OF_STATUS_ERROR_LOGS = 5;
    private static final int MAX_LOG_MESSAGE_LENGTH = 500;
    static final String DEFAULT_JAVA_APPLICATION = "Default Java Application";
    private final String id = UUID.randomUUID().toString();
    private final InsightsConfiguration insightsConfiguration;
    private AtomicInteger numberOfStatusEventErrors = new AtomicInteger();
    private final Cluster cluster;
    private final Session session;
    private final Supplier<Long> timestampSupplier;
    private final PlatformInfoFinder platformInfoFinder;
    private final ReconnectionPolicyInfoFinder reconnectionPolicyInfoInfoFinder;
    private final ExecutionProfilesInfoFinder executionProfilesInfoFinder;
    private final ConfigAntiPatternsFinder configAntiPatternsFinder;
    private final DataCentersFinder dataCentersFinder;
    private final StackTraceElement[] initCallerStackTrace;
    private ScheduledFuture<?> scheduleInsightsTask;

    static InsightsClient createInsightsClient(Cluster cluster, InsightsConfiguration insightsConfiguration, Session session, StackTraceElement[] initCallerStackTrace) {
        SpeculativeExecutionInfoFinder speculativeExecutionInfoFinder = new SpeculativeExecutionInfoFinder();
        DataCentersFinder dataCentersFinder = new DataCentersFinder();
        return new InsightsClient(cluster, session, new Supplier<Long>(){

            @Override
            public Long get() {
                return new Date().getTime();
            }
        }, insightsConfiguration, new PlatformInfoFinder(), new ReconnectionPolicyInfoFinder(), new ExecutionProfilesInfoFinder(speculativeExecutionInfoFinder, dataCentersFinder), new ConfigAntiPatternsFinder(), dataCentersFinder, initCallerStackTrace);
    }

    InsightsClient(Cluster cluster, Session session, Supplier<Long> timestampSupplier, InsightsConfiguration insightsConfiguration, PlatformInfoFinder platformInfoFinder, ReconnectionPolicyInfoFinder reconnectionPolicyInfoInfoFinder, ExecutionProfilesInfoFinder executionProfilesInfoFinder, ConfigAntiPatternsFinder configAntiPatternsFinder, DataCentersFinder dataCentersFinder, StackTraceElement[] initCallerStackTrace) {
        this.cluster = cluster;
        this.session = session;
        this.timestampSupplier = timestampSupplier;
        this.insightsConfiguration = insightsConfiguration;
        this.platformInfoFinder = platformInfoFinder;
        this.reconnectionPolicyInfoInfoFinder = reconnectionPolicyInfoInfoFinder;
        this.executionProfilesInfoFinder = executionProfilesInfoFinder;
        this.configAntiPatternsFinder = configAntiPatternsFinder;
        this.dataCentersFinder = dataCentersFinder;
        this.initCallerStackTrace = initCallerStackTrace;
    }

    ListenableFuture<Void> sendStartupMessage() {
        if (!this.shouldSendEvent()) {
            return Futures.immediateCancelledFuture();
        }
        final String startupMessage = this.createStartupMessage();
        final Connection.Future write = this.sendJsonMessage(startupMessage);
        if (write == null) {
            return Futures.immediateCancelledFuture();
        }
        return GuavaCompatibility.INSTANCE.transformAsync(write, new AsyncFunction<Message.Response, Void>(){

            @Override
            public ListenableFuture<Void> apply(Message.Response response) {
                if (response.type == Message.Response.Type.ERROR) {
                    DriverException ex = ((Responses.Error)response).asException(write.getEndPoint());
                    LOGGER.debug("Error while sending: " + InsightsClient.trimToFirst500characters(startupMessage) + " to insights. Aborting sending all future: " + InsightsClient.STARTUP_MESSAGE_NAME + " events", ex);
                }
                return Futures.immediateFuture(null);
            }
        });
    }

    void scheduleStatusMessageSend() {
        if (!this.shouldSendEvent()) {
            return;
        }
        this.scheduleInsightsTask = InsightsClient.scheduleInsightsTask(this.insightsConfiguration.getStatusEventDelayMillis(), this.cluster.getManager().scheduledTasksExecutor, new Runnable(){

            @Override
            public void run() {
                InsightsClient.this.sendStatusMessage();
            }
        });
    }

    void shutdown() {
        if (this.scheduleInsightsTask != null) {
            this.scheduleInsightsTask.cancel(false);
        }
    }

    @VisibleForTesting
    ListenableFuture<Void> sendStatusMessage() {
        final String statusMessage = this.createStatusMessage();
        final Connection.Future write = this.sendJsonMessage(statusMessage);
        if (write == null) {
            return Futures.immediateCancelledFuture();
        }
        return GuavaCompatibility.INSTANCE.transformAsync(write, new AsyncFunction<Message.Response, Void>(){

            @Override
            public ListenableFuture<Void> apply(Message.Response response) {
                if (response.type == Message.Response.Type.ERROR) {
                    DriverException ex = ((Responses.Error)response).asException(write.getEndPoint());
                    if (InsightsClient.this.numberOfStatusEventErrors.getAndIncrement() < 5) {
                        LOGGER.debug("Error while sending: " + InsightsClient.trimToFirst500characters(statusMessage) + " to insights.", ex);
                    }
                }
                return Futures.immediateFuture(null);
            }
        });
    }

    private Connection.Future sendJsonMessage(String jsonMessage) {
        Requests.QueryProtocolOptions options = this.createQueryOptionsWithJson(jsonMessage);
        Requests.Query query = new Requests.Query(REPORT_INSIGHT_RPC, options, false);
        Connection connection = this.getControlConnection().connectionRef.get();
        if (connection != null) {
            LOGGER.trace("Sending message: {}", (Object)jsonMessage);
            return connection.write(query);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Could not send message: {} \u2013 control connection is not initialized", (Object)InsightsClient.trimToFirst500characters(jsonMessage));
        }
        return null;
    }

    private boolean shouldSendEvent() {
        return this.insightsConfiguration.isMonitorReportingEnabled() && InsightsSupportVerifier.supportsInsights(this.cluster);
    }

    private Requests.QueryProtocolOptions createQueryOptionsWithJson(String json) {
        ByteBuffer startupMessageSerialized = TypeCodec.varchar().serialize(json, ProtocolVersion.DSE_V2);
        return Requests.QueryProtocolOptions.DEFAULT.copy(new ByteBuffer[]{startupMessageSerialized});
    }

    @VisibleForTesting
    String createStartupMessage() {
        InsightsSchema.InsightsMetadata insightsMetadata = this.createMetadata(STARTUP_MESSAGE_NAME, "v1");
        InsightsSchema.InsightsStartupData data = this.createStartupData();
        try {
            return OBJECT_MAPPER.writeValueAsString(new InsightsSchema.Insight<InsightsSchema.InsightsStartupData>(insightsMetadata, data));
        }
        catch (JsonProcessingException e) {
            throw new InsightEventFormatException("Could not create: driver.startup", e);
        }
    }

    @VisibleForTesting
    String createStatusMessage() {
        InsightsSchema.InsightsMetadata insightsMetadata = this.createMetadata(STATUS_MESSAGE_NAME, "v1");
        InsightsSchema.InsightsStatusData data = this.createStatusData();
        try {
            return OBJECT_MAPPER.writeValueAsString(new InsightsSchema.Insight<InsightsSchema.InsightsStatusData>(insightsMetadata, data));
        }
        catch (JsonProcessingException e) {
            throw new InsightEventFormatException("Could not create: driver.status", e);
        }
    }

    private InsightsSchema.InsightsStatusData createStatusData() {
        Map<String, String> startupOptions = this.cluster.getManager().getStartupOptions();
        return InsightsSchema.InsightsStatusData.builder().withClientId(this.getClientId(startupOptions)).withSessionId(this.id).withControlConnection(this.getControlConnectionSocketAddress()).withConnectedNodes(this.getConnectedNodes()).build();
    }

    private Map<String, InsightsSchema.SessionStateForNode> getConnectedNodes() {
        LinkedHashMap<String, InsightsSchema.SessionStateForNode> sessionStates = new LinkedHashMap<String, InsightsSchema.SessionStateForNode>();
        Session.State state = this.session.getState();
        Collection<Host> connectedHosts = state.getConnectedHosts();
        for (Host h : connectedHosts) {
            int inFlightQueries = state.getInFlightQueries(h);
            int openConnections = state.getOpenConnections(h);
            sessionStates.put(AddressFormatter.nullSafeToString(h.getEndPoint().resolve()), new InsightsSchema.SessionStateForNode(openConnections, inFlightQueries));
        }
        return sessionStates;
    }

    private InsightsSchema.InsightsStartupData createStartupData() {
        Map<String, String> startupOptions = this.cluster.getManager().getStartupOptions();
        return InsightsSchema.InsightsStartupData.builder().withClientId(this.getClientId(startupOptions)).withSessionId(this.id).withApplicationName(this.getApplicationName(startupOptions)).withApplicationVersion(this.getApplicationVersion(startupOptions)).withDriverName("DataStax Enterprise Java Driver").withDriverVersion(Cluster.getDriverVersion()).withContactPoints(this.cluster.getManager().getResolvedContactPoints()).withInitialControlConnection(this.getControlConnectionSocketAddress()).withProtocolVersion(this.cluster.getManager().protocolVersion().toInt()).withLocalAddress(this.getLocalAddress()).withExecutionProfiles(this.executionProfilesInfoFinder.getExecutionProfilesInfo(this.cluster)).withPoolSizeByHostDistance(this.getPoolSizeByHostDistance()).withHeartbeatInterval(TimeUnit.SECONDS.toMillis(this.cluster.getConfiguration().getPoolingOptions().getHeartbeatIntervalSeconds())).withCompression(this.cluster.getConfiguration().getProtocolOptions().getCompression()).withReconnectionPolicy(this.reconnectionPolicyInfoInfoFinder.getReconnectionPolicyInfo(this.cluster.getManager().reconnectionPolicy())).withSsl(this.getSsl()).withAuthProvider(this.getAuthProvider()).withOtherOptions(Collections.<String, Object>emptyMap()).withPlatformInfo(this.platformInfoFinder.getInsightsPlatformInfo()).withConfigAntiPatterns(this.configAntiPatternsFinder.findAntiPatterns(this.cluster)).withPeriodicStatusInterval(TimeUnit.MILLISECONDS.toSeconds(this.insightsConfiguration.getStatusEventDelayMillis())).withHostName(this.getLocalHostName()).withApplicationNameWasGenerated(this.isApplicationNameGenerated(startupOptions)).withDataCenters(this.dataCentersFinder.getDataCenters(this.cluster)).build();
    }

    private InsightsSchema.AuthProviderType getAuthProvider() {
        Class<?> authProviderClass = this.cluster.getConfiguration().getProtocolOptions().getAuthProvider().getClass();
        return new InsightsSchema.AuthProviderType(authProviderClass.getSimpleName(), PackageUtil.getNamespace(authProviderClass));
    }

    private String getClientId(Map<String, String> startupOptions) {
        return startupOptions.get("CLIENT_ID");
    }

    private boolean isApplicationNameGenerated(Map<String, String> startupOptions) {
        return startupOptions.get("APPLICATION_NAME") == null;
    }

    private String getApplicationVersion(Map<String, String> startupOptions) {
        String applicationVersion = startupOptions.get("APPLICATION_VERSION");
        if (applicationVersion == null) {
            return "";
        }
        return applicationVersion;
    }

    private String getApplicationName(Map<String, String> startupOptions) {
        String applicationName = startupOptions.get("APPLICATION_NAME");
        if (applicationName == null || applicationName.isEmpty()) {
            return InsightsClient.getClusterCreateCaller(this.initCallerStackTrace);
        }
        return applicationName;
    }

    @VisibleForTesting
    static String getClusterCreateCaller(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length - 1; ++i) {
            int nextElement;
            if (!InsightsClient.isClusterStackTrace(stackTrace[i]) || InsightsClient.isClusterStackTrace(stackTrace[nextElement = i + 1])) continue;
            return stackTrace[nextElement].getClassName();
        }
        return DEFAULT_JAVA_APPLICATION;
    }

    private static boolean isClusterStackTrace(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().equals(Cluster.class.getName()) || stackTraceElement.getClassName().equals(DelegatingCluster.class.getName()) || stackTraceElement.getClassName().equals(DseCluster.class.getName());
    }

    private String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Can not resolve the name of a host, returning null", e);
            return null;
        }
    }

    private InsightsSchema.SSL getSsl() {
        boolean isSslDefined = this.cluster.getConfiguration().getProtocolOptions().getSSLOptions() != null;
        return new InsightsSchema.SSL(isSslDefined);
    }

    private InsightsSchema.PoolSizeByHostDistance getPoolSizeByHostDistance() {
        return new InsightsSchema.PoolSizeByHostDistance(this.cluster.getConfiguration().getPoolingOptions().getCoreConnectionsPerHost(HostDistance.LOCAL), this.cluster.getConfiguration().getPoolingOptions().getCoreConnectionsPerHost(HostDistance.REMOTE), this.cluster.getConfiguration().getPoolingOptions().getCoreConnectionsPerHost(HostDistance.IGNORED));
    }

    private String getControlConnectionSocketAddress() {
        return this.getControlConnection().connectedHost() != null ? AddressFormatter.nullSafeToString(this.getControlConnection().connectedHost().getEndPoint().resolve()) : null;
    }

    private ControlConnection getControlConnection() {
        return this.cluster.getManager().getControlConnection();
    }

    private String getLocalAddress() {
        return this.getControlConnection().connectedHost() != null ? AddressFormatter.nullSafeToString(this.getControlConnection().connectedHost().getEndPoint().resolve().getAddress()) : null;
    }

    private InsightsSchema.InsightsMetadata createMetadata(String messageName, String messageVersion) {
        return new InsightsSchema.InsightsMetadata(messageName, this.timestampSupplier.get(), TAGS, InsightsSchema.InsightType.EVENT, messageVersion);
    }

    @VisibleForTesting
    static ScheduledFuture<?> scheduleInsightsTask(long statusEventDelayMillis, ScheduledExecutorService scheduledTasksExecutor, Runnable runnable) {
        long initialDelay = (long)Math.floor((double)statusEventDelayMillis - InsightsClient.zeroToTenPercentRandom(statusEventDelayMillis));
        return scheduledTasksExecutor.scheduleWithFixedDelay(runnable, initialDelay, statusEventDelayMillis, TimeUnit.MILLISECONDS);
    }

    private static double zeroToTenPercentRandom(Long statusEventDelayMillis) {
        return 0.1 * (double)statusEventDelayMillis.longValue() * Math.random();
    }

    private static String trimToFirst500characters(String startupMessage) {
        return startupMessage.substring(0, Math.min(startupMessage.length(), 500));
    }
}

