/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.VersionNumber;
import java.util.Set;

class InsightsSupportVerifier {
    private static final VersionNumber minDse6Version = VersionNumber.parse("6.0.5");
    private static final VersionNumber minDse51Version = VersionNumber.parse("5.1.13");
    private static final VersionNumber dse600Version = VersionNumber.parse("6.0.0");

    InsightsSupportVerifier() {
    }

    static boolean supportsInsights(Cluster cluster) {
        Set<Host> allHosts = cluster.getMetadata().getAllHosts();
        if (allHosts.isEmpty()) {
            return false;
        }
        for (Host host : allHosts) {
            VersionNumber dseVersion = host.getDseVersion();
            if (dseVersion == null) {
                return false;
            }
            if (dseVersion.compareTo(minDse6Version) >= 0 || dseVersion.compareTo(dse600Version) < 0 && dseVersion.compareTo(minDse51Version) >= 0) continue;
            return false;
        }
        return true;
    }
}

