/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.OptionalLong;
import java.util.Set;

public class M3PTokenFilter {
    private final TokenRange[] ranges;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    private final Metadata clusterMetadata;
    private final Token.Factory factory;

    public M3PTokenFilter(Set<TokenRange> ranges, Cluster cluster) {
        this.protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        this.codecRegistry = cluster.getConfiguration().getCodecRegistry();
        this.clusterMetadata = cluster.getMetadata();
        this.factory = Token.getFactory(this.clusterMetadata.partitioner);
        ArrayList<TokenRange> rangeList = new ArrayList<TokenRange>();
        for (TokenRange range : ranges) {
            if (!range.getStart().getType().equals(DataType.bigint())) {
                throw new RuntimeException("This filter only works with bigint valued token types");
            }
            rangeList.add(range);
        }
        this.ranges = rangeList.toArray(new TokenRange[0]);
        if (this.ranges.length < 1) {
            throw new RuntimeException("There were no tokens found. Please check your keyspace and cluster settings.");
        }
    }

    public OptionalLong matches(Statement statement) {
        ByteBuffer routingKey = statement.getRoutingKey(this.protocolVersion, this.codecRegistry);
        Token token = this.factory.hash(routingKey);
        for (TokenRange range : this.ranges) {
            if (!range.contains(token)) continue;
            return OptionalLong.of((Long)token.getValue());
        }
        return OptionalLong.empty();
    }
}

