/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.SystemProperties;
import com.datastax.internal.com_google_common.base.Throwables;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NettyUtil {
    private static final boolean FORCE_NIO;
    private static final Logger LOGGER;
    private static final boolean USE_EPOLL;
    private static final Constructor<? extends EventLoopGroup> EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR;
    private static final Class<? extends SocketChannel> EPOLL_CHANNEL_CLASS;
    private static final Class[] EVENT_GROUP_ARGUMENTS;
    private static final String SHADING_DETECTION_STRING = "io.netty.shadingdetection.ShadingDetection";
    private static final boolean SHADED;

    NettyUtil() {
    }

    public static boolean isShaded() {
        return SHADED;
    }

    public static boolean isEpollAvailable() {
        return USE_EPOLL;
    }

    public static EventLoopGroup newEventLoopGroupInstance(ThreadFactory factory) {
        if (NettyUtil.isEpollAvailable()) {
            try {
                return EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR.newInstance(0, factory);
            }
            catch (Exception e) {
                throw Throwables.propagate(e);
            }
        }
        return new NioEventLoopGroup(0, factory);
    }

    public static Class<? extends SocketChannel> channelClass() {
        if (NettyUtil.isEpollAvailable()) {
            return EPOLL_CHANNEL_CLASS;
        }
        return NioSocketChannel.class;
    }

    static {
        boolean useEpoll;
        block11: {
            FORCE_NIO = SystemProperties.getBoolean("com.datastax.driver.FORCE_NIO", false);
            LOGGER = LoggerFactory.getLogger(NettyUtil.class);
            EVENT_GROUP_ARGUMENTS = new Class[]{Integer.TYPE, ThreadFactory.class};
            SHADED = !SHADING_DETECTION_STRING.equals(String.format("%s.%s.shadingdetection.ShadingDetection", "io", "netty"));
            useEpoll = false;
            if (!SHADED) {
                try {
                    Class<?> epoll = Class.forName("io.netty.channel.epoll.Epoll");
                    if (FORCE_NIO) {
                        LOGGER.info("Found Netty's native epoll transport in the classpath, but NIO was forced through the FORCE_NIO system property.");
                        break block11;
                    }
                    if (!System.getProperty("os.name", "").toLowerCase(Locale.US).equals("linux")) {
                        LOGGER.warn("Found Netty's native epoll transport, but not running on linux-based operating system. Using NIO instead.");
                        break block11;
                    }
                    if (!((Boolean)epoll.getMethod("isAvailable", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                        LOGGER.warn("Found Netty's native epoll transport in the classpath, but epoll is not available. Using NIO instead.", (Throwable)epoll.getMethod("unavailabilityCause", new Class[0]).invoke(null, new Object[0]));
                        break block11;
                    }
                    LOGGER.info("Found Netty's native epoll transport in the classpath, using it");
                    useEpoll = true;
                }
                catch (ClassNotFoundException e) {
                    LOGGER.info("Did not find Netty's native epoll transport in the classpath, defaulting to NIO.");
                }
                catch (Exception e) {
                    LOGGER.warn("Unexpected error trying to find Netty's native epoll transport in the classpath, defaulting to NIO.", e);
                }
            } else {
                LOGGER.info("Detected shaded Netty classes in the classpath; native epoll transport will not work properly, defaulting to NIO.");
            }
        }
        USE_EPOLL = useEpoll;
        Constructor<?> constructor = null;
        Class<?> channelClass = null;
        if (USE_EPOLL) {
            try {
                channelClass = Class.forName("io.netty.channel.epoll.EpollSocketChannel");
                Class<?> epoolEventLoupGroupClass = Class.forName("io.netty.channel.epoll.EpollEventLoopGroup");
                constructor = epoolEventLoupGroupClass.getDeclaredConstructor(EVENT_GROUP_ARGUMENTS);
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Netty's native epoll is in use but cannot locate Epoll classes, this should not happen: " + e));
            }
        }
        EPOLL_EVENT_LOOP_GROUP_CONSTRUCTOR = constructor;
        EPOLL_CHANNEL_CLASS = channelClass;
    }
}

