/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import io.nosqlbench.activitytype.cql.api.StatementFilter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class TokenRangeStmtFilter
implements StatementFilter {
    private final Metadata clusterMetadata;
    private final ProtocolVersion protocolVersion;
    private final CodecRegistry codecRegistry;
    private final Token.Factory factory;
    private TokenRange[] ranges;

    public TokenRangeStmtFilter(Cluster cluster, String rangesSpec) {
        this.clusterMetadata = cluster.getMetadata();
        this.protocolVersion = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        this.codecRegistry = cluster.getConfiguration().getCodecRegistry();
        this.factory = Token.getFactory(this.clusterMetadata.partitioner);
        this.ranges = this.parseRanges(this.factory, rangesSpec);
    }

    private TokenRange[] parseRanges(Token.Factory factory, String rangesStr) {
        String[] ranges = rangesStr.split(",");
        ArrayList<TokenRange> tr = new ArrayList<TokenRange>();
        for (String range : ranges) {
            String[] interval = range.split(":");
            Token start = factory.fromString(interval[0]);
            Token end = factory.fromString(interval[1]);
            TokenRange tokenRange = new TokenRange(start, end, factory);
            tr.add(tokenRange);
        }
        return tr.toArray(new TokenRange[tr.size()]);
    }

    @Override
    public boolean matches(Statement statement) {
        ByteBuffer routingKey = statement.getRoutingKey(this.protocolVersion, this.codecRegistry);
        Token token = this.factory.hash(routingKey);
        for (TokenRange range : this.ranges) {
            if (!range.contains(token)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "including token ranges: " + Arrays.stream(this.ranges).map(String::valueOf).collect(Collectors.joining(","));
    }
}

