/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.internal.com_google_common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EC2MultiRegionAddressTranslator
implements AddressTranslator {
    private static final Logger logger = LoggerFactory.getLogger(EC2MultiRegionAddressTranslator.class);
    private final DirContext ctx;

    public EC2MultiRegionAddressTranslator() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new DriverException("Could not create translator", e);
        }
    }

    @VisibleForTesting
    EC2MultiRegionAddressTranslator(DirContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public InetSocketAddress translate(InetSocketAddress socketAddress) {
        InetAddress address = socketAddress.getAddress();
        try {
            String domainName = this.lookupPtrRecord(EC2MultiRegionAddressTranslator.reverse(address));
            if (domainName == null) {
                logger.warn("Found no domain name for {}, returning it as-is", (Object)address);
                return socketAddress;
            }
            InetAddress translatedAddress = InetAddress.getByName(domainName);
            logger.debug("Resolved {} to {}", (Object)address, (Object)translatedAddress);
            return new InetSocketAddress(translatedAddress, socketAddress.getPort());
        }
        catch (Exception e) {
            logger.warn("Error resolving " + address + ", returning it as-is", e);
            return socketAddress;
        }
    }

    private String lookupPtrRecord(String reversedDomain) throws Exception {
        Attributes attrs = this.ctx.getAttributes(reversedDomain, new String[]{"PTR"});
        NamingEnumeration<? extends Attribute> ae = attrs.getAll();
        while (ae.hasMoreElements()) {
            Attribute attr = ae.next();
            NamingEnumeration<?> vals = attr.getAll();
            if (!vals.hasMoreElements()) continue;
            return vals.nextElement().toString();
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException e) {
            logger.warn("Error closing translator", e);
        }
    }

    @VisibleForTesting
    static String reverse(InetAddress address) {
        byte[] bytes = address.getAddress();
        if (bytes.length == 4) {
            return EC2MultiRegionAddressTranslator.reverseIpv4(bytes);
        }
        return EC2MultiRegionAddressTranslator.reverseIpv6(bytes);
    }

    private static String reverseIpv4(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = bytes.length - 1; i >= 0; --i) {
            builder.append(bytes[i] & 0xFF).append('.');
        }
        builder.append("in-addr.arpa");
        return builder.toString();
    }

    private static String reverseIpv6(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = bytes.length - 1; i >= 0; --i) {
            byte b = bytes[i];
            int lowNibble = b & 0xF;
            int highNibble = b >> 4 & 0xF;
            builder.append(Integer.toHexString(lowNibble)).append('.').append(Integer.toHexString(highNibble)).append('.');
        }
        builder.append("ip6.arpa");
        return builder.toString();
    }
}

