/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PercentileTracker;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.internal.com_google_common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;

public class PercentileSpeculativeExecutionPolicy
implements SpeculativeExecutionPolicy {
    private final PercentileTracker percentileTracker;
    private final double percentile;
    private final int maxSpeculativeExecutions;

    public PercentileSpeculativeExecutionPolicy(PercentileTracker percentileTracker, double percentile, int maxSpeculativeExecutions) {
        Preconditions.checkArgument(maxSpeculativeExecutions > 0, "number of speculative executions must be strictly positive (was %d)", maxSpeculativeExecutions);
        Preconditions.checkArgument(percentile >= 0.0 && percentile < 100.0, "percentile must be between 0.0 and 100 (was %f)");
        this.percentileTracker = percentileTracker;
        this.percentile = percentile;
        this.maxSpeculativeExecutions = maxSpeculativeExecutions;
    }

    @Override
    public SpeculativeExecutionPolicy.SpeculativeExecutionPlan newPlan(String loggedKeyspace, Statement statement) {
        return new SpeculativeExecutionPolicy.SpeculativeExecutionPlan(){
            private final AtomicInteger remaining;
            {
                this.remaining = new AtomicInteger(PercentileSpeculativeExecutionPolicy.this.maxSpeculativeExecutions);
            }

            @Override
            public long nextExecution(Host lastQueried) {
                if (this.remaining.getAndDecrement() > 0) {
                    return PercentileSpeculativeExecutionPolicy.this.percentileTracker.getLatencyAtPercentile(lastQueried, null, null, PercentileSpeculativeExecutionPolicy.this.percentile);
                }
                return -1L;
            }
        };
    }

    @Override
    public void init(Cluster cluster) {
        cluster.register(this.percentileTracker);
    }

    @Override
    public void close() {
    }

    public double getPercentile() {
        return this.percentile;
    }

    public int getMaxSpeculativeExecutions() {
        return this.maxSpeculativeExecutions;
    }
}

