/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.AbstractCreateStatement;
import com.datastax.driver.core.schemabuilder.ColumnType;
import com.datastax.internal.com_google_common.base.Joiner;
import com.datastax.internal.com_google_common.base.Optional;
import java.util.ArrayList;
import java.util.Map;

public class CreateType
extends AbstractCreateStatement<CreateType> {
    private String typeName;

    CreateType(String keyspaceName, String typeName) {
        CreateType.validateNotEmpty(keyspaceName, "Keyspace name");
        CreateType.validateNotEmpty(typeName, "Custom type name");
        CreateType.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        CreateType.validateNotKeyWord(typeName, String.format("The custom type name '%s' is not allowed because it is a reserved keyword", typeName));
        this.typeName = typeName;
        this.keyspaceName = Optional.fromNullable(keyspaceName);
    }

    CreateType(String typeName) {
        CreateType.validateNotEmpty(typeName, "Custom type name");
        CreateType.validateNotKeyWord(typeName, String.format("The custom type name '%s' is not allowed because it is a reserved keyword", typeName));
        this.typeName = typeName;
    }

    public String build() {
        return this.buildInternal();
    }

    @Override
    public String buildInternal() {
        StringBuilder createStatement = new StringBuilder("\n\t").append("CREATE TYPE ");
        if (this.ifNotExists) {
            createStatement.append("IF NOT EXISTS ");
        }
        if (this.keyspaceName.isPresent()) {
            createStatement.append((String)this.keyspaceName.get()).append(".");
        }
        createStatement.append(this.typeName);
        ArrayList<String> allColumns = new ArrayList<String>();
        for (Map.Entry<String, ColumnType> entry : this.simpleColumns.entrySet()) {
            allColumns.add(this.buildColumnType(entry));
        }
        createStatement.append("(").append("\n\t\t");
        createStatement.append(Joiner.on(",\n\t\t").join(allColumns));
        createStatement.append(")");
        return createStatement.toString();
    }
}

