/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.ChainableLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.dse.HostTargetingStatement;
import com.datastax.internal.com_google_common.collect.AbstractIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DseLoadBalancingPolicy
implements ChainableLoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DseLoadBalancingPolicy.class);
    private final LoadBalancingPolicy childPolicy;
    private Set<Host> upHosts = Collections.newSetFromMap(new ConcurrentHashMap());

    public DseLoadBalancingPolicy(LoadBalancingPolicy childPolicy) {
        this.childPolicy = childPolicy;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        this.upHosts.addAll(hosts);
        this.childPolicy.init(cluster, hosts);
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
        final Host preferredHost = statement instanceof HostTargetingStatement ? ((HostTargetingStatement)statement).preferredHost : null;
        final Iterator<Host> childPlan = this.childPolicy.newQueryPlan(loggedKeyspace, statement);
        if (preferredHost == null) {
            return childPlan;
        }
        if (!this.upHosts.contains(preferredHost)) {
            logger.debug("Received statement targeted to {}, but it's not available at the moment", (Object)preferredHost);
            return childPlan;
        }
        logger.debug("Received statement targeted to {}, moving it to the beginning of the query plan", (Object)preferredHost);
        return new AbstractIterator<Host>(){
            volatile boolean first = true;

            @Override
            protected Host computeNext() {
                if (this.first) {
                    this.first = false;
                    return preferredHost;
                }
                if (childPlan.hasNext()) {
                    Host next = (Host)childPlan.next();
                    if (next.equals(preferredHost)) {
                        return childPlan.hasNext() ? (Host)childPlan.next() : (Host)this.endOfData();
                    }
                    return next;
                }
                return (Host)this.endOfData();
            }
        };
    }

    @Override
    public HostDistance distance(Host host) {
        return this.childPolicy.distance(host);
    }

    @Override
    public void onAdd(Host host) {
        this.upHosts.add(host);
        this.childPolicy.onAdd(host);
    }

    @Override
    public void onUp(Host host) {
        this.upHosts.add(host);
        this.childPolicy.onUp(host);
    }

    @Override
    public void onDown(Host host) {
        this.upHosts.remove(host);
        this.childPolicy.onDown(host);
    }

    @Override
    public void onRemove(Host host) {
        this.upHosts.remove(host);
        this.childPolicy.onRemove(host);
    }

    @Override
    public LoadBalancingPolicy getChildPolicy() {
        return this.childPolicy;
    }

    @Override
    public void close() {
        this.childPolicy.close();
    }
}

