/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.core.Authenticator;

abstract class BaseDseAuthenticator
implements Authenticator {
    private static final String DSE_AUTHENTICATOR = "com.datastax.bdp.cassandra.auth.DseAuthenticator";
    private final String authenticator;

    protected BaseDseAuthenticator(String authenticator) {
        this.authenticator = authenticator;
    }

    public abstract byte[] getMechanism();

    public abstract byte[] getInitialServerChallenge();

    @Override
    public byte[] initialResponse() {
        if (this.isDseAuthenticator()) {
            return this.getMechanism();
        }
        return this.evaluateChallenge(this.getInitialServerChallenge());
    }

    @Override
    public void onAuthenticationSuccess(byte[] token) {
    }

    private boolean isDseAuthenticator() {
        return this.authenticator.equals(DSE_AUTHENTICATOR);
    }
}

