/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.dse.auth.BaseDseAuthenticator;
import com.datastax.internal.com_google_common.base.Charsets;
import com.datastax.internal.com_google_common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class DseGSSAPIAuthProvider
implements AuthProvider {
    public static final String DEFAULT_SASL_PROTOCOL_NAME = "dse";
    public static final String SASL_PROTOCOL_NAME_PROPERTY = "dse.sasl.protocol";
    public static final Map<String, String> DEFAULT_SASL_PROPERTIES = ImmutableMap.builder().put("javax.security.sasl.server.authentication", "true").put("javax.security.sasl.qop", "auth").build();
    private final Configuration loginConfiguration;
    private final String saslProtocol;
    private final String authorizationId;
    private final Subject subject;
    private final Map<String, String> properties;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public DseGSSAPIAuthProvider() {
        this(null, null, null, null, DEFAULT_SASL_PROPERTIES);
    }

    @Deprecated
    public DseGSSAPIAuthProvider(Configuration loginConfiguration) {
        this(loginConfiguration, null, null, null, DEFAULT_SASL_PROPERTIES);
    }

    @Deprecated
    public DseGSSAPIAuthProvider(String saslProtocol) {
        this(null, null, saslProtocol, null, DEFAULT_SASL_PROPERTIES);
    }

    @Deprecated
    public DseGSSAPIAuthProvider(Configuration loginConfiguration, String saslProtocol) {
        this(loginConfiguration, null, saslProtocol, null, DEFAULT_SASL_PROPERTIES);
    }

    private DseGSSAPIAuthProvider(Configuration loginConfiguration, Subject subject, String saslProtocol, String authorizationId, Map<String, String> properties) {
        this.loginConfiguration = loginConfiguration;
        this.subject = subject;
        this.saslProtocol = saslProtocol;
        this.authorizationId = authorizationId;
        this.properties = ImmutableMap.copyOf(properties);
    }

    @Override
    public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
        if (this.subject != null) {
            return new GSSAPIAuthenticator(authenticator, this.authorizationId, host, this.subject, this.saslProtocol, this.properties);
        }
        return new GSSAPIAuthenticator(authenticator, this.authorizationId, host, this.loginConfiguration, this.saslProtocol, this.properties);
    }

    private static class GSSAPIAuthenticator
    extends BaseDseAuthenticator {
        private static final String JAAS_CONFIG_ENTRY = "DseClient";
        private static final String[] SUPPORTED_MECHANISMS = new String[]{"GSSAPI"};
        private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
        private static final byte[] MECHANISM = "GSSAPI".getBytes(Charsets.UTF_8);
        private static final byte[] SERVER_INITIAL_CHALLENGE = "GSSAPI-START".getBytes(Charsets.UTF_8);
        private final Subject subject;
        private final SaslClient saslClient;

        private GSSAPIAuthenticator(String authenticator, String authorizationId, InetSocketAddress host, Configuration loginConfiguration, String saslProtocol, Map<String, String> properties) {
            super(authenticator);
            try {
                String protocol = saslProtocol;
                if (protocol == null) {
                    protocol = System.getProperty(DseGSSAPIAuthProvider.SASL_PROTOCOL_NAME_PROPERTY, DseGSSAPIAuthProvider.DEFAULT_SASL_PROTOCOL_NAME);
                }
                LoginContext login = new LoginContext(JAAS_CONFIG_ENTRY, null, null, loginConfiguration);
                login.login();
                this.subject = login.getSubject();
                this.saslClient = Sasl.createSaslClient(SUPPORTED_MECHANISMS, authorizationId, protocol, host.getAddress().getCanonicalHostName(), properties, null);
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }

        private GSSAPIAuthenticator(String authenticator, String authorizationId, InetSocketAddress host, Subject subject, String saslProtocol, Map<String, String> properties) {
            super(authenticator);
            try {
                String protocol = saslProtocol;
                if (protocol == null) {
                    protocol = System.getProperty(DseGSSAPIAuthProvider.SASL_PROTOCOL_NAME_PROPERTY, DseGSSAPIAuthProvider.DEFAULT_SASL_PROTOCOL_NAME);
                }
                this.subject = subject;
                this.saslClient = Sasl.createSaslClient(SUPPORTED_MECHANISMS, authorizationId, protocol, host.getAddress().getCanonicalHostName(), properties, null);
            }
            catch (SaslException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] getMechanism() {
            return (byte[])MECHANISM.clone();
        }

        @Override
        public byte[] getInitialServerChallenge() {
            return (byte[])SERVER_INITIAL_CHALLENGE.clone();
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) {
            if (Arrays.equals(SERVER_INITIAL_CHALLENGE, challenge)) {
                if (!this.saslClient.hasInitialResponse()) {
                    return EMPTY_BYTE_ARRAY;
                }
                challenge = EMPTY_BYTE_ARRAY;
            }
            final byte[] internalChallenge = challenge;
            try {
                return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return GSSAPIAuthenticator.this.saslClient.evaluateChallenge(internalChallenge);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException(e.getException());
            }
        }
    }

    public static class Builder {
        private Configuration loginConfiguration;
        private String saslProtocol;
        private String authorizationId;
        private Subject subject;
        private Map<String, String> properties = new HashMap<String, String>(DEFAULT_SASL_PROPERTIES);

        private Builder() {
        }

        public Builder withLoginConfiguration(Configuration loginConfiguration) {
            this.loginConfiguration = loginConfiguration;
            return this;
        }

        public Builder withSaslProtocol(String saslProtocol) {
            this.saslProtocol = saslProtocol;
            return this;
        }

        public Builder withAuthorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder withSubject(Subject subject) {
            this.subject = subject;
            return this;
        }

        public Builder addSaslProperty(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public DseGSSAPIAuthProvider build() {
            return new DseGSSAPIAuthProvider(this.loginConfiguration, this.subject, this.saslProtocol, this.authorizationId, this.properties);
        }
    }
}

